/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.timers;

import java.util.Vector;
import org.w3c.tools.timers.Event;
import org.w3c.tools.timers.EventHandler;

public class EventManager
extends Thread
implements EventHandler {
    static final boolean debug = false;
    Vector queue = new Vector();
    boolean done = false;

    public EventManager() {
        this.setName("Event Manager");
    }

    public Object registerTimer(long l, EventHandler eventHandler, Object object) {
        long l2 = l + System.currentTimeMillis();
        Event event = new Event(l2, eventHandler, object);
        return this.registerTimer(event);
    }

    public synchronized void stopEventManager() {
        this.done = true;
        this.notify();
    }

    public synchronized Object registerTimer(Event event) {
        int n = 0;
        int n2 = this.queue.size();
        long l = event.time;
        if (this.done) {
            return null;
        }
        if (n2 == 0) {
            this.queue.addElement(event);
        } else {
            while (n2 - n > 0) {
                int n3 = n2 + n >> 1;
                Event event2 = (Event)this.queue.elementAt(n3);
                long l2 = event2.time;
                if (l2 < l) {
                    n = n3 + 1;
                    continue;
                }
                if (l2 > l) {
                    n2 = n3;
                    continue;
                }
                n = n3;
                break;
            }
            if (n < n2 && ((Event)this.queue.elementAt((int)n)).time > l) {
                ++n;
            }
            this.queue.insertElementAt(event, n);
        }
        this.notify();
        return event;
    }

    public synchronized Object recallTimer(Object object) {
        Event event;
        int n;
        int n2 = 0;
        int n3 = n = this.queue.size();
        long l = ((Event)object).time;
        if (n == 0) {
            return null;
        }
        block0: while (n - n2 > 0) {
            int n4 = n + n2 >> 1;
            event = (Event)this.queue.elementAt(n4);
            long l2 = event.time;
            if (l2 < l) {
                n2 = n4 + 1;
                continue;
            }
            if (l2 > l) {
                n = n4;
                continue;
            }
            n2 = n4;
            int n5 = n4 - 1;
            while (n5 >= 0) {
                event = (Event)this.queue.elementAt(n5);
                if (event.time != l2) break block0;
                n2 = n5--;
            }
            break block0;
        }
        while (n2 < n3) {
            event = (Event)this.queue.elementAt(n2);
            if (event.time == l) {
                if (event == object) {
                    this.queue.removeElementAt(n2);
                    break;
                }
                ++n2;
                continue;
            }
            return null;
        }
        if (n2 == 0) {
            this.notify();
        }
        return object;
    }

    synchronized Event getNextEvent() {
        while (true) {
            if (this.queue.size() == 0) {
                if (this.done) {
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Event event = (Event)this.queue.elementAt(0);
            long l = System.currentTimeMillis();
            long l2 = event.time - l;
            if (l2 <= 0L) {
                this.queue.removeElementAt(0);
                return event;
            }
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(9);
        while (true) {
            Event event = this.getNextEvent();
            if (this.done) break;
            try {
                event.handler.handleTimerEvent(event.data, event.time);
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception + " in EventManager");
                exception.printStackTrace();
            }
            catch (Error error) {
                System.out.println("Error " + error + " in EventManager");
                error.printStackTrace();
            }
        }
    }

    public void handleTimerEvent(Object object, long l) {
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Handling event with dt=" + l2);
    }

    public static void main(String[] stringArray) {
        EventManager eventManager = new EventManager();
        for (int i = 0; i < 30; ++i) {
            eventManager.registerTimer(1000 + (int)(1000.0 * Math.random()), eventManager, null);
        }
        eventManager.checkQueue();
    }

    synchronized void checkQueue() {
        Vector vector = this.queue;
        if (vector.size() == 0) {
            return;
        }
        Event event = (Event)vector.elementAt(0);
        int n = vector.size();
        for (int i = 1; i < n; ++i) {
            Event event2 = (Event)vector.elementAt(i);
            if (event2.time < event.time) {
                System.out.println("Events out of order!\n");
                System.out.println(vector);
            }
            event = event2;
        }
    }
}

