/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpWarningList;
import org.w3c.www.http.ParseState;

public class HttpWarning
extends BasicValue {
    public static final int STALE = 110;
    public static final int REVALIDATION_FAILED = 111;
    public static final int DISCONNECTED_OPERATION = 112;
    public static final int HEURISTIC_EXPIRATION = 113;
    public static final int MISCELLANEOUS = 199;
    public static final int TRANSFORMATION_APPLIED = 214;
    public static final int PERSISTENT_MISCELLANEOUS = 199;
    protected HttpWarningList list = null;
    protected int status = -1;
    protected String agent = null;
    protected String text = null;

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        ParseState parseState2 = new ParseState();
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid warning, no status code.");
        }
        parseState2.ioff = parseState.start;
        parseState2.bufend = parseState.end;
        this.status = HttpParser.parseInt(this.raw, parseState2);
        parseState.prepare();
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid warning, no agent field.");
        }
        this.agent = new String(this.raw, 0, parseState.start, parseState.end - parseState.start);
        parseState.prepare();
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid warning, no text message.");
        }
        parseState2.ioff = parseState.start;
        parseState2.bufend = parseState.end;
        HttpParser.unquote(this.raw, parseState2);
        this.text = new String(this.raw, 0, parseState2.start, parseState2.end - parseState2.start);
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.appendInt(this.status);
        httpBuffer.append(' ');
        httpBuffer.append(this.agent);
        httpBuffer.append(' ');
        httpBuffer.appendQuoted(this.text);
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    protected void invalidateByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    public int getStatus() {
        this.validate();
        return this.status;
    }

    public void setStatus(int n) {
        if (this.status != n) {
            this.invalidateByteValue();
        }
        this.status = n;
    }

    public String getAgent() {
        this.validate();
        return this.agent;
    }

    public void setAgent(String string) {
        if (string != null && !string.equals(this.agent)) {
            this.invalidateByteValue();
        }
        this.agent = string;
    }

    public String getText() {
        this.validate();
        return this.text;
    }

    public void setText(String string) {
        if (string != null && !string.equals(this.text)) {
            this.invalidateByteValue();
        }
        this.text = string;
    }

    HttpWarning(HttpWarningList httpWarningList, byte[] byArray, int n, int n2) {
        this.list = httpWarningList;
        this.raw = byArray;
        this.roff = n;
        this.rlen = n2;
        this.isValid = false;
    }

    HttpWarning(boolean bl, int n, String string, String string2) {
        this.isValid = bl;
        this.setStatus(n);
        this.setAgent(string);
        this.setText(string2);
    }

    public HttpWarning() {
        this.isValid = false;
    }
}

