/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.tool;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.util.DefaultReportImpl;
import java.io.File;

public class Checker {
    public static void main(String[] args) {
        EpubCheck check;
        String epubName = Checker.processArguments(args);
        DefaultReportImpl report = new DefaultReportImpl(epubName);
        if (!epubName.endsWith(".epub")) {
            report.warning(null, 0, "filename does not include '.epub' suffix");
        }
        if ((check = new EpubCheck(new File(epubName), report)).validate()) {
            System.out.println("No errors or warnings detected");
        } else {
            System.err.println("\nCheck finished with warnings or errors!\n");
            System.exit(1);
        }
    }

    public static String processArguments(String[] args) {
        Checker.displayVersion();
        if (args.length < 1) {
            System.err.println("At least one argument expected");
            System.exit(1);
        }
        String epubName = new String("");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-version") || args[i].equals("-v")) {
                Checker.displayVersion();
            }
            if (args[i].equals("-help") || args[i].equals("-?")) {
                Checker.displayHelp();
            }
            if (args[i].length() <= 5 || !args[i].substring(args[i].length() - 5).equals(".epub")) continue;
            epubName = args[i];
        }
        if (!epubName.equals("")) {
            return epubName;
        }
        System.err.println("No .epub file to check was specified in arguments!");
        System.err.println("The tool will EXIT!");
        System.exit(1);
        return null;
    }

    public static void displayHelp() {
        Checker.displayVersion();
        System.out.println("When running this tool, the first argument should be the name (and path) of the file to check.");
        System.out.println("This tool also accepts the following flags:");
        System.out.println("-? or -help \t= displays this help message");
        System.out.println("-v or -version \t= displays the tool's version number\n");
    }

    public static void displayVersion() {
        System.out.println("Epubcheck Version 1.1\n");
    }
}

