/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.ClosableFrame;
import org.w3c.tools.widgets.ListEditor;
import org.w3c.util.ArrayDictionary;

public class HashtableAttributeEditor
extends AttributeEditor {
    protected boolean hasChanged = false;
    protected HashtableAttributeComponent comp = null;
    protected ArrayDictionary oldValue = null;

    public Component getComponent() {
        return this.comp;
    }

    protected void createComponent(ArrayDictionary arrayDictionary) {
        if (this.comp == null) {
            this.comp = new HashtableAttributeComponent(this, arrayDictionary);
        }
    }

    protected void setModified() {
        this.hasChanged = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void clearChanged() {
        this.hasChanged = false;
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.comp.setTable(this.oldValue);
    }

    public Object getValue() {
        return this.comp.getTable();
    }

    public void setValue(Object object) {
        this.oldValue = (ArrayDictionary)object;
        this.comp.setTable(this.oldValue);
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        this.createComponent((ArrayDictionary)object);
        this.oldValue = (ArrayDictionary)object;
    }

    class HashtableAttributeComponent
    extends ListEditor {
        protected HashtableAttributeEditor editor = null;
        protected HashtableAttributePopup popup = null;
        protected ArrayDictionary hashtable = null;

        protected void edit() {
            if (this.popup == null) {
                this.popup = new HashtableAttributePopup(this, (ArrayDictionary)this.hashtable.clone(), "Edit");
            } else {
                this.popup.start((ArrayDictionary)this.hashtable.clone());
            }
            this.popup.show();
            this.popup.toFront();
        }

        protected void setModified() {
            this.editor.setModified();
        }

        protected void setTable(ArrayDictionary arrayDictionary) {
            if (arrayDictionary == null) {
                this.hashtable = new ArrayDictionary(5);
                return;
            }
            this.hashtable = arrayDictionary;
            Enumeration enumeration = arrayDictionary.keys();
            this.list.removeAll();
            while (enumeration.hasMoreElements()) {
                this.list.addItem((String)enumeration.nextElement());
            }
        }

        protected ArrayDictionary getTable() {
            return this.hashtable;
        }

        HashtableAttributeComponent(HashtableAttributeEditor hashtableAttributeEditor2, ArrayDictionary arrayDictionary) {
            super(3, false);
            this.editor = hashtableAttributeEditor2;
            this.setTable(arrayDictionary);
        }
    }

    class HashtableAttributePopup
    extends ClosableFrame
    implements ActionListener,
    ItemListener {
        protected HashtableAttributeComponent parent = null;
        protected ArrayDictionary table = null;
        protected List keys = null;
        protected TextField tkey = null;
        protected TextField tvalue = null;
        protected boolean modified = false;
        protected String selectedKey = null;

        public void itemStateChanged(ItemEvent itemEvent) {
            Integer n;
            String string;
            if (itemEvent.getStateChange() == 1 && (string = this.keys.getItem(n = (Integer)itemEvent.getItem())) != null) {
                String string2 = (String)this.table.get(string);
                this.tkey.setText(string);
                this.selectedKey = string;
                this.tvalue.setText(string2);
                this.tkey.requestFocus();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("add")) {
                String string2 = this.tkey.getText();
                String string3 = this.tvalue.getText();
                if (string2.length() > 0) {
                    this.table.put(string2, string3);
                    this.updateKeys();
                    this.modified = true;
                }
            } else if (string.equals("replace")) {
                if (this.selectedKey != null) {
                    this.table.remove(this.selectedKey);
                }
                String string4 = this.tkey.getText();
                String string5 = this.tvalue.getText();
                if (string4.length() > 0) {
                    this.table.put(string4, string5);
                    this.updateKeys();
                    this.modified = true;
                }
            } else if (string.equals("del")) {
                int[] nArray = this.keys.getSelectedIndexes();
                if (nArray != null && nArray.length > 0) {
                    int n;
                    this.modified = true;
                    for (n = 0; n < nArray.length; ++n) {
                        String string6 = this.keys.getItem(nArray[n]);
                        this.table.remove(string6);
                        this.keys.deselect(nArray[n]);
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        this.keys.delItem(nArray[n] - n);
                    }
                }
                this.tkey.setText("");
                this.tvalue.setText("");
            } else if (string.equals("update")) {
                if (this.modified) {
                    this.parent.setTable(this.table);
                    this.parent.setModified();
                    this.modified = false;
                }
                this.tkey.setText("");
                this.tvalue.setText("");
                this.setVisible(false);
            } else if (string.equals("cancel")) {
                this.close();
            } else if (actionEvent.getSource() == this.tkey) {
                this.tvalue.requestFocus();
            } else if (actionEvent.getSource() == this.tvalue) {
                String string7 = this.tkey.getText();
                String string8 = this.tvalue.getText();
                if (string7.length() > 0) {
                    this.table.put(string7, string8);
                    this.updateKeys();
                    this.modified = true;
                }
                this.tkey.requestFocus();
            }
        }

        protected void close() {
            this.modified = false;
            this.tkey.setText("");
            this.tvalue.setText("");
            this.setVisible(false);
        }

        protected void updateKeys() {
            this.tkey.setText("");
            this.tvalue.setText("");
            this.keys.removeAll();
            Enumeration enumeration = this.table.keys();
            while (enumeration.hasMoreElements()) {
                this.keys.addItem((String)enumeration.nextElement());
            }
        }

        protected void updateSize() {
            this.setSize(350, 230);
        }

        public void start(ArrayDictionary arrayDictionary) {
            this.table = arrayDictionary;
            this.updateKeys();
            this.selectedKey = null;
            this.modified = false;
        }

        HashtableAttributePopup(HashtableAttributeComponent hashtableAttributeComponent, ArrayDictionary arrayDictionary, String string) {
            super(string);
            this.parent = hashtableAttributeComponent;
            this.table = arrayDictionary;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.setLayout(gridBagLayout);
            Label label = new Label("Key");
            Label label2 = new Label("Value");
            this.tkey = new TextField(15);
            this.tkey.addActionListener(this);
            this.tvalue = new TextField(15);
            this.tvalue.addActionListener(this);
            this.keys = new List(5, true);
            this.keys.addItemListener(this);
            Button button = new Button("add");
            button.setActionCommand("add");
            button.addActionListener(this);
            Button button2 = new Button("Remove");
            button2.setActionCommand("del");
            button2.addActionListener(this);
            Button button3 = new Button("Replace");
            button3.setActionCommand("replace");
            button3.addActionListener(this);
            Button button4 = new Button("Ok");
            button4.setActionCommand("update");
            button4.addActionListener(this);
            Button button5 = new Button("Cancel");
            button5.setActionCommand("cancel");
            button5.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.add(label);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(label2, gridBagConstraints);
            this.add(label2);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(this.tkey, gridBagConstraints);
            this.add(this.tkey);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.tvalue, gridBagConstraints);
            this.add(this.tvalue);
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(this.keys, gridBagConstraints);
            this.add(this.keys);
            gridBagConstraints.fill = 0;
            Panel panel = new Panel(new BorderLayout());
            panel.add((Component)button, "North");
            panel.add((Component)button3, "Center");
            panel.add((Component)button2, "South");
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.add(panel);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(button4, gridBagConstraints);
            this.add(button4);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(button5, gridBagConstraints);
            this.add(button5);
            this.updateSize();
            this.updateKeys();
        }
    }
}

