/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.store;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.SpaceEntry;
import org.w3c.tools.resources.event.ResourceEventQueue;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.store.NewStoreEntry;
import org.w3c.tools.resources.store.ResourceStoreImpl;
import org.w3c.tools.resources.store.ResourceStoreState;
import org.w3c.tools.resources.store.StoreEntry;
import org.w3c.tools.resources.store.StoreManagerSweeper;
import org.w3c.util.AsyncLRUList;
import org.w3c.util.LRUList;

public class ResourceStoreManager
implements ResourceSpace {
    public static boolean debug = false;
    public static final int SUBDIRS = 128;
    public static final String ROOT_REP = "root.xml";
    public static final String STATE_F = "state.xml";
    public boolean debugMemory = false;
    protected Serializer serializer = null;
    Hashtable entries = new Hashtable(256);
    private int storeSizeLimit = -1;
    private int maxLoadedStore = -1;
    private int loadedStore = 0;
    protected boolean closed = false;
    protected File storedir = null;
    protected File index = null;
    protected String server_name = null;
    protected File root_repository = null;
    protected LRUList lru = null;
    protected ResourceStoreState state = null;
    protected StoreManagerSweeper sweeper = null;
    protected ResourceEventQueue eventQueue = null;

    public ResourceEventQueue getEventQueue() {
        if (this.eventQueue == null) {
            this.eventQueue = new ResourceEventQueue();
        }
        return this.eventQueue;
    }

    protected final int getMaxLoadedStore() {
        return this.maxLoadedStore;
    }

    protected final int getStoreSizeLimit() {
        return this.storeSizeLimit;
    }

    protected synchronized void incrLoadedStore() {
        ++this.loadedStore;
        this.checkMaxLoadedStore();
    }

    protected synchronized void decrLoadedStore() {
        --this.loadedStore;
    }

    protected final synchronized void checkClosed() {
        if (this.closed) {
            throw new RuntimeException("Invalid store manager access.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NewStoreEntry pickLRUEntry() {
        NewStoreEntry newStoreEntry;
        LRUList lRUList = this.lru;
        synchronized (lRUList) {
            newStoreEntry = (NewStoreEntry)this.lru.removeTail();
        }
        return newStoreEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        if (this.debugMemory) {
            System.out.println("[MEMORY] start sweeper <- " + this.loadedStore + " stores loaded.");
        }
        NewStoreEntry newStoreEntry = null;
        NewStoreEntry newStoreEntry2 = null;
        int n = this.getMaxLoadedStore();
        while (this.loadedStore > n && (newStoreEntry2 = this.pickLRUEntry()) != null && newStoreEntry2 != newStoreEntry) {
            NewStoreEntry newStoreEntry3 = newStoreEntry2;
            synchronized (newStoreEntry3) {
                if (!newStoreEntry2.unloadStore()) {
                    LRUList lRUList = this.lru;
                    synchronized (lRUList) {
                        this.lru.toHead(newStoreEntry2);
                        if (newStoreEntry == null) {
                            newStoreEntry = newStoreEntry2;
                        }
                    }
                }
            }
        }
        if (this.debugMemory) {
            System.out.println("[MEMORY] sweeper done  -> " + this.loadedStore + " stores still loaded.");
        }
    }

    public synchronized String createResourceStoreRepository() {
        int n = this.state.getNextKey();
        return n % 128 + "/st-" + n;
    }

    public int getCurrentStoreIdentifier() {
        return this.state.getCurrentKey();
    }

    protected boolean checkSubDirs() {
        for (int i = 0; i < 128; ++i) {
            File file = new File(this.storedir, Integer.toString(i));
            if (file.exists() || file.mkdirs()) continue;
            return false;
        }
        return true;
    }

    protected File getIndexFile() {
        if (this.index == null) {
            this.index = new File(this.storedir, this.server_name + "-index.xml");
        }
        return this.index;
    }

    protected File getOldIndexFile() {
        if (this.index == null) {
            this.index = new File(this.storedir, this.server_name + "-index");
        }
        return this.index;
    }

    protected File getRootRepository() {
        if (this.root_repository == null) {
            this.root_repository = new File(this.storedir, ROOT_REP);
        }
        return this.root_repository;
    }

    protected Integer getRootKey() {
        return new Integer(new String("root").hashCode());
    }

    protected void warning(String string) {
        System.out.println("********* WARNING *********");
        System.out.println("[" + this.getClass().getName() + "]:\n" + string);
        System.out.println("***************************");
    }

    protected synchronized void saveNewEntriesIndex() {
        Object[] objectArray;
        File file = this.getIndexFile();
        String string = file.getParent();
        String string2 = file.getName();
        File file2 = new File(string, string2 + ".tmp");
        File file3 = new File(string, string2 + ".bak");
        File file4 = new File(string, string2 + ".bak~");
        Enumeration enumeration = this.entries.elements();
        Vector<Object[]> vector = new Vector<Object[]>(10);
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray.isTransient()) continue;
            vector.addElement(objectArray);
        }
        objectArray = new NewStoreEntry[vector.size()];
        vector.copyInto(objectArray);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            this.serializer.writeResources((AttributeHolder[])objectArray, bufferedWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to save entries index");
        }
        if (file4.exists()) {
            file4.delete();
        }
        if (file3.exists()) {
            file3.renameTo(file4);
            file3.delete();
        }
        if (file.exists()) {
            if (!file.renameTo(file3)) {
                this.warning("unable to rename " + file + " to " + file3);
                file4.renameTo(file3);
            }
            file.delete();
        }
        if (!file2.renameTo(file)) {
            file3.renameTo(file);
            file4.renameTo(file3);
            this.warning("unable to rename " + file2 + " to " + file);
        }
        file4.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadNewEntriesIndex() {
        Object object;
        File file = this.getIndexFile();
        if (!file.exists()) {
            object = new File(file.getParent(), file.getName() + ".bak");
            if (((File)object).exists()) {
                this.warning(file + " not found! using bak file :" + object);
                if (!((File)object).renameTo(file)) {
                    this.warning("unable to rename " + object + " to " + file + "\n Try by yourself or all your resources will be lost!");
                    System.exit(-1);
                }
            } else {
                this.entries = new Hashtable(256);
                return;
            }
        }
        this.entries = new Hashtable(256);
        try {
            object = new BufferedReader(new FileReader(file));
            AttributeHolder[] attributeHolderArray = this.serializer.readAttributeHolders((Reader)object);
            for (int i = 0; i < attributeHolderArray.length; ++i) {
                NewStoreEntry newStoreEntry = (NewStoreEntry)attributeHolderArray[i];
                this.entries.put(newStoreEntry.getKey(), newStoreEntry);
                LRUList lRUList = this.lru;
                synchronized (lRUList) {
                    this.lru.toHead(newStoreEntry);
                }
                newStoreEntry.initialize(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to load entries index");
        }
    }

    public static synchronized void updateEntriesIndex(File file, File file2, Serializer serializer) throws IOException {
        Object object;
        AttributeHolder[] attributeHolderArray;
        Object object2;
        Hashtable hashtable = new Hashtable();
        if (!file.exists()) {
            object2 = new File(file.getParent(), file.getName() + ".bak");
            if (((File)object2).exists()) {
                System.out.println(file.getAbsolutePath() + " not found! using bak file :" + object2);
                if (!((File)object2).renameTo(file)) {
                    System.out.println("unable to rename " + object2 + " to " + file + "\n Try by yourself or all your resources will be lost!");
                    System.exit(-1);
                }
            } else {
                return;
            }
        }
        object2 = null;
        try {
            object2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            hashtable = (Hashtable)((ObjectInputStream)object2).readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new RuntimeException("Unable to load entries index");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Unable to load entries index");
        }
        finally {
            if (object2 != null) {
                try {
                    ((ObjectInputStream)object2).close();
                }
                catch (Exception exception) {}
            }
        }
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            attributeHolderArray = (AttributeHolder[])enumeration.nextElement();
            if (attributeHolderArray.isTransient()) {
                hashtable.remove(attributeHolderArray.key);
                continue;
            }
            ++n;
            String string = attributeHolderArray.repository;
            if (string == null) continue;
            if (string.equals("root.idx")) {
                attributeHolderArray.repository = ROOT_REP;
                continue;
            }
            int n2 = Integer.parseInt(string.substring(3));
            attributeHolderArray.repository = n2 % 128 + "/" + string;
        }
        enumeration = hashtable.elements();
        attributeHolderArray = new NewStoreEntry[n];
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            StoreEntry storeEntry = (StoreEntry)enumeration.nextElement();
            object = new NewStoreEntry(null, storeEntry.repository, storeEntry.key);
            attributeHolderArray[n3++] = object;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        object = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
        serializer.writeResources(attributeHolderArray, bufferedWriter);
    }

    public synchronized void shutdown() {
        Object object;
        this.saveNewEntriesIndex();
        this.sweeper.shutdown();
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            object = (NewStoreEntry)enumeration.nextElement();
            ((NewStoreEntry)object).shutdownStore();
            this.entries.remove(((NewStoreEntry)object).getKey());
        }
        this.closed = true;
        object = new File(this.storedir, STATE_F);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            AttributeHolder[] attributeHolderArray = new AttributeHolder[]{this.state};
            this.serializer.writeResources(attributeHolderArray, bufferedWriter);
        }
        catch (Exception exception) {
            System.out.println("ResourceStoreManager: unable to save state !");
            exception.printStackTrace();
        }
    }

    public void checkpoint() {
        Object object;
        try {
            this.saveNewEntriesIndex();
        }
        catch (Exception exception) {
            System.out.println("*** Error during checkpoint");
        }
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            object = (NewStoreEntry)enumeration.nextElement();
            try {
                ((NewStoreEntry)object).saveStore();
            }
            catch (Exception exception) {
                if (object == null) {
                    System.out.println("*** Error, saving null entry!");
                    continue;
                }
                System.out.println("*** Error while saving store " + ((NewStoreEntry)object).getKey());
            }
        }
        object = new File(this.storedir, STATE_F);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            AttributeHolder[] attributeHolderArray = new AttributeHolder[]{this.state};
            this.serializer.writeResources(attributeHolderArray, bufferedWriter);
        }
        catch (Exception exception) {
            System.out.println("ResourceStoreManager: unable to save state !");
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUsed(Object object) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)object;
        if (newStoreEntry != null) {
            LRUList lRUList = this.lru;
            synchronized (lRUList) {
                this.lru.toHead(newStoreEntry);
            }
        }
    }

    protected boolean used(String string) {
        Enumeration enumeration = this.entries.elements();
        NewStoreEntry newStoreEntry = null;
        while (enumeration.hasMoreElements()) {
            newStoreEntry = (NewStoreEntry)enumeration.nextElement();
            System.out.println(this.storedir + ":" + newStoreEntry.getRepository());
            try {
                if (!newStoreEntry.getRepository().getName().equals(string)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public void salvage() {
        String[] stringArray = this.storedir.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 3 || !stringArray[i].startsWith("st-") || stringArray[i].endsWith(".bak") || this.used(stringArray[i])) continue;
                System.err.println("*** " + stringArray[i] + " not used! deleted");
                File file = new File(this.storedir, stringArray[i]);
                file.delete();
            }
        }
    }

    public void displayIndex() {
        Enumeration enumeration = this.entries.elements();
        NewStoreEntry newStoreEntry = null;
        System.out.println("Index : ");
        while (enumeration.hasMoreElements()) {
            newStoreEntry = (NewStoreEntry)enumeration.nextElement();
            System.out.println(newStoreEntry.getKey() + " : " + newStoreEntry.getRepository());
        }
    }

    public ResourceStoreState salvageState() {
        System.err.println("*** salvaging resource manager state...");
        File file = new File(this.storedir, STATE_F);
        int n = -1;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("st-") && !string.endsWith(".bak");
            }
        };
        for (int i = 0; i < 128; ++i) {
            File file2 = new File(this.storedir, Integer.toString(i));
            if (!file2.exists()) continue;
            String[] stringArray = file2.list(filenameFilter);
            for (int j = 0; j < stringArray.length; ++j) {
                int n2 = Integer.parseInt(stringArray[j].substring(3));
                n = Math.max(n, n2);
            }
        }
        System.err.println("*** resource store state salvaged, using: " + ++n);
        return new ResourceStoreState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceReference loadRootResource(String string, Hashtable hashtable) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(this.getRootKey());
        if (newStoreEntry == null) {
            ResourceStoreManager resourceStoreManager = this;
            synchronized (resourceStoreManager) {
                newStoreEntry = (NewStoreEntry)this.entries.get(this.getRootKey());
                if (newStoreEntry == null) {
                    newStoreEntry = new NewStoreEntry(this, ROOT_REP, this.getRootKey());
                    this.entries.put(this.getRootKey(), newStoreEntry);
                }
            }
        }
        return newStoreEntry.loadResource(string, hashtable);
    }

    public boolean checkKey(Integer n) {
        if (this.entries != null) {
            return !this.entries.containsKey(n);
        }
        return true;
    }

    public ResourceReference lookupResource(SpaceEntry spaceEntry, String string) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to lookup resource (" + string + "), no StoreEntry for its space entry");
        }
        return newStoreEntry.lookupResource(string);
    }

    public ResourceReference loadResource(SpaceEntry spaceEntry, String string, Hashtable hashtable) {
        NewStoreEntry newStoreEntry;
        if (debug) {
            System.out.println("[RSM] loading [" + string + "] from [" + spaceEntry + ']');
        }
        if ((newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey())) == null) {
            throw new RuntimeException(string + ": Space Entry not valid");
        }
        return newStoreEntry.loadResource(string, hashtable);
    }

    public ResourceReference addResource(SpaceEntry spaceEntry, Resource resource, Hashtable hashtable) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to add resource (" + resource.getIdentifier() + "), no StoreEntry for its space entry");
        }
        return newStoreEntry.addResource(resource, hashtable);
    }

    public void saveResource(SpaceEntry spaceEntry, Resource resource) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to save resource (" + resource.getIdentifier() + "), no StoreEntry for its space entry");
        }
        newStoreEntry.saveResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markModified(SpaceEntry spaceEntry, Resource resource) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to mark resource (" + resource.getIdentifier() + "), no StoreEntry for its space entry");
        }
        Resource resource2 = resource;
        synchronized (resource2) {
            newStoreEntry.markModified(resource);
        }
    }

    public void renameResource(SpaceEntry spaceEntry, String string, String string2) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to rename resource (" + string + " to " + string2 + "), no StoreEntry for its space entry");
        }
        newStoreEntry.renameResource(string, string2);
    }

    public void deleteResource(SpaceEntry spaceEntry, Resource resource) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to delete resource (" + resource.getIdentifier() + "), no StoreEntry for its space entry");
        }
        newStoreEntry.removeResource(resource.getIdentifier());
    }

    public void deleteChildren(SpaceEntry spaceEntry) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to delete children, no StoreEntry for its space entry");
        }
        newStoreEntry.deleteStore();
        this.entries.remove(spaceEntry.getEntryKey());
    }

    public void saveChildren(SpaceEntry spaceEntry) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to save children, no StoreEntry for its space entry");
        }
        newStoreEntry.saveStore();
    }

    protected void checkMaxLoadedStore() {
        if (this.loadedStore > this.getMaxLoadedStore()) {
            this.sweeper.sweep();
        }
    }

    public void acquireChildren(SpaceEntry spaceEntry, File file, boolean bl) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            this.checkMaxLoadedStore();
            newStoreEntry = new NewStoreEntry(this, file, spaceEntry.getEntryKey());
            newStoreEntry.setTransient(bl);
            this.entries.put(spaceEntry.getEntryKey(), newStoreEntry);
        } else {
            newStoreEntry.rep = file;
        }
    }

    public void acquireChildren(SpaceEntry spaceEntry) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            this.checkMaxLoadedStore();
            String string = this.createResourceStoreRepository();
            File file = new File(this.storedir, string);
            if (file.exists()) {
                String string2 = new String(string);
                String string3 = null;
                do {
                    string3 = new String(string);
                } while ((file = new File(this.storedir, string = this.createResourceStoreRepository())).exists());
                if (string2.equals(string3)) {
                    this.warning("repository " + string2 + " exists! using " + string);
                } else {
                    this.warning("repositories " + string2 + " to " + string3 + " exists! using " + string);
                }
            }
            newStoreEntry = new NewStoreEntry(this, string, spaceEntry.getEntryKey());
            this.entries.put(spaceEntry.getEntryKey(), newStoreEntry);
        }
    }

    public String getHTMLStatus() {
        Enumeration enumeration = this.entries.elements();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            int n6;
            NewStoreEntry newStoreEntry = (NewStoreEntry)enumeration.nextElement();
            if (newStoreEntry.references != null && (n6 = newStoreEntry.references.size()) > 0) {
                n += n6;
                ++n2;
            }
            if (newStoreEntry.store == null) continue;
            ResourceStoreImpl resourceStoreImpl = (ResourceStoreImpl)newStoreEntry.store;
            if (resourceStoreImpl.resources == null || (n6 = resourceStoreImpl.resources.size()) <= 0) continue;
            int n7 = resourceStoreImpl.resources.size();
            n3 += n7;
            ++n4;
            if (this.storeSizeLimit <= 0 || n7 <= this.storeSizeLimit) continue;
            ++n5;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table border=\"1\" class=\"store\">\n<caption>Resource Store usage</caption>\n<tr><th>Loaded Stores</th><th>Loaded Entries</th></tr>\n");
        stringBuffer.append("<tr><td>");
        stringBuffer.append(this.loadedStore);
        stringBuffer.append(" (");
        stringBuffer.append(this.entries.size());
        stringBuffer.append(") / ");
        stringBuffer.append(this.maxLoadedStore);
        if (this.storeSizeLimit >= 0) {
            stringBuffer.append(" [");
            stringBuffer.append(n5);
            stringBuffer.append(" > ");
            stringBuffer.append(this.storeSizeLimit);
            stringBuffer.append(" ]");
        }
        stringBuffer.append("</td><td>");
        stringBuffer.append(n);
        stringBuffer.append('(');
        stringBuffer.append(n2);
        stringBuffer.append(')');
        stringBuffer.append(" / ");
        stringBuffer.append(n3);
        stringBuffer.append('(');
        stringBuffer.append(n4);
        stringBuffer.append(")</td>\n</table>");
        return stringBuffer.toString();
    }

    public Enumeration enumerateResourceIdentifiers(SpaceEntry spaceEntry) {
        NewStoreEntry newStoreEntry = (NewStoreEntry)this.entries.get(spaceEntry.getEntryKey());
        if (newStoreEntry == null) {
            throw new RuntimeException("Unable to list children, no StoreEntry for its space entry");
        }
        return newStoreEntry.enumerateResourceIdentifiers();
    }

    public ResourceStoreManager(String string, File file, String string2, String string3, String string4, int n, Hashtable hashtable) {
        this(string, file, string2, string3, string4, n, -1, hashtable);
    }

    public ResourceStoreManager(String string, File file, String string2, String string3, String string4, int n, int n2, Hashtable hashtable) {
        Object object;
        Object object2;
        Serializable serializable;
        this.server_name = string;
        this.storedir = file;
        this.entries = new Hashtable();
        this.sweeper = new StoreManagerSweeper(this);
        this.lru = new AsyncLRUList();
        this.maxLoadedStore = n < 10 ? 10 : n;
        this.storeSizeLimit = n2 < 100 ? -1 : n2;
        this.loadedStore = 0;
        try {
            serializable = Class.forName(string4);
            this.serializer = (Serializer)serializable.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Invalid serializer class : " + string4);
        }
        this.loadNewEntriesIndex();
        if (!this.checkSubDirs()) {
            throw new RuntimeException("Unable to create store subdirectories!");
        }
        this.getRootRepository();
        if (!this.root_repository.exists()) {
            try {
                serializable = Class.forName(string2);
                object2 = (Resource)serializable.newInstance();
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>(4);
                }
                hashtable.put("identifier".intern(), string3);
                hashtable.put("key".intern(), (String)((Object)this.getRootKey()));
                ((Resource)object2).initialize(hashtable);
                object = new NewStoreEntry(this, ROOT_REP, this.getRootKey());
                ResourceReference resourceReference = ((NewStoreEntry)object).addResource((Resource)object2, hashtable);
                ResourceContext resourceContext = (ResourceContext)hashtable.get("context");
                resourceContext.setResourceReference(resourceReference);
                ((NewStoreEntry)object).saveResource((Resource)object2);
                this.entries.put(this.getRootKey(), object);
                this.saveNewEntriesIndex();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.getMessage());
                classNotFoundException.printStackTrace();
            }
        }
        serializable = new File(file, STATE_F);
        object2 = null;
        try {
            object2 = new BufferedReader(new FileReader((File)serializable));
            object = this.serializer.readAttributeHolders((Reader)object2);
            this.state = (ResourceStoreState)object[0];
        }
        catch (Exception exception) {
            this.state = this.salvageState();
        }
        if (object2 != null) {
            try {
                ((Reader)object2).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

