/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Properties;
import java.util.Vector;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.ResourceEditorInterface;
import org.w3c.jigadm.editors.ResourceHelper;
import org.w3c.jigadm.editors.ResourceHelperFactory;
import org.w3c.jigadm.events.ResourceChangeEvent;
import org.w3c.jigadm.events.ResourceListener;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.widgets.BorderPanel;
import org.w3c.tools.widgets.MessagePopup;

public class ResourceEditor
implements ResourceEditorInterface {
    public static final String UNREMOVABLE_P = "unremovable";
    protected Vector rls = null;
    Panel target = null;
    Panel buttonp = null;
    Panel editorp = null;
    Button commitb = null;
    Button resetb;
    RemoteResource rr = null;
    RemoteResourceWrapper rrw = null;
    ResourceHelper[] rh = null;
    protected Button[] b = null;
    protected Label message = null;
    Properties p;
    protected static final String DELETE_L = "Delete";
    protected static final String REINDEX_L = "Reindex";

    public void setMessage(String string) {
        this.message.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges() throws RemoteAccessException {
        for (int i = 0; i < this.rh.length; ++i) {
            if (!this.rh[i].hasChanged()) continue;
            boolean bl = false;
            while (!bl) {
                try {
                    bl = true;
                    this.rh[i].commitChanges();
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                        continue;
                    }
                    new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
                    throw remoteAccessException;
                }
                finally {
                    if (bl) continue;
                    this.rrw.getBrowser().popupDialog("admin");
                }
            }
        }
    }

    public void resetChanges() throws RemoteAccessException {
        for (int i = 0; i < this.rh.length; ++i) {
            if (!this.rh[i].hasChanged()) continue;
            this.rh[i].resetChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchHelper(Button button) throws RemoteAccessException {
        for (int i = 0; i < this.b.length; ++i) {
            if (!button.equals(this.b[i])) continue;
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Properties properties = propertyManager.getHelperProperties(this.rrw, this.rh[i].getClass().getName());
            boolean bl = false;
            while (!bl) {
                try {
                    bl = true;
                    this.rh[i].initialize(this.rrw, properties);
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                        continue;
                    }
                    new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
                    throw remoteAccessException;
                }
                finally {
                    if (bl) continue;
                    this.rrw.getBrowser().popupDialog("admin");
                }
            }
            this.editorp.setVisible(false);
            this.editorp.removeAll();
            this.editorp.add("Center", this.rh[i].getComponent());
            this.editorp.validate();
            this.editorp.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindex() {
        boolean bl = false;
        while (!bl) {
            try {
                bl = true;
                this.rrw.getResource().reindex(true);
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    bl = false;
                    continue;
                }
                new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
            }
            finally {
                if (bl) continue;
                this.rrw.getBrowser().popupDialog("admin");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete() {
        boolean bl = false;
        while (!bl) {
            try {
                bl = true;
                this.rrw.getResource().delete();
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    bl = false;
                    continue;
                }
                new MessagePopup("Exception : ", remoteAccessException.getMessage()).show();
            }
            finally {
                if (bl) continue;
                this.rrw.getBrowser().popupDialog("admin");
            }
        }
        this.processEvent(new ResourceChangeEvent(this.rrw.getFatherWrapper(), "deleted", this.rrw, null));
    }

    public boolean hasChanged() {
        for (int i = 0; i < this.rh.length; ++i) {
            if (!this.rh[i].hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void clearChanged() {
        for (int i = 0; i < this.rh.length; ++i) {
            if (!this.rh[i].hasChanged()) continue;
            this.rh[i].clearChanged();
        }
    }

    public RemoteResource getValue() {
        return this.rr;
    }

    public synchronized void addResourceListener(ResourceListener resourceListener) {
        if (this.rls == null) {
            this.rls = new Vector(2);
        }
        this.rls.addElement(resourceListener);
    }

    public synchronized void removeResourceListener(ResourceListener resourceListener) {
        if (this.rls != null) {
            this.rls.removeElement(resourceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(EventObject eventObject) {
        Vector vector = null;
        ResourceEditor resourceEditor = this;
        synchronized (resourceEditor) {
            if (this.rls == null || !(eventObject instanceof ResourceChangeEvent)) {
                return;
            }
            vector = (Vector)this.rls.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ResourceListener resourceListener = (ResourceListener)vector.elementAt(i);
            resourceListener.resourceChanged((ResourceChangeEvent)eventObject);
        }
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Properties properties) throws RemoteAccessException {
        int n = 0;
        this.rrw = remoteResourceWrapper;
        this.rr = remoteResourceWrapper.getResource();
        ButtonBarListener buttonBarListener = new ButtonBarListener();
        this.p = properties;
        this.target.removeAll();
        BorderPanel borderPanel = new BorderPanel(4, 2);
        borderPanel.setLayout(new BorderLayout());
        this.rh = ResourceHelperFactory.getHelpers(remoteResourceWrapper);
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        Properties properties2 = propertyManager.getEditorProperties(remoteResourceWrapper);
        if (properties2 == null || properties2.getProperty(UNREMOVABLE_P, "false").equalsIgnoreCase("false")) {
            MouseButtonListener mouseButtonListener = new MouseButtonListener();
            Panel panel = new Panel(new BorderLayout());
            Button button = new Button(DELETE_L);
            button.addActionListener(buttonBarListener);
            button.addMouseListener(mouseButtonListener);
            panel.add("West", button);
            this.message = new Label("", 1);
            this.message.setBackground(Color.gray);
            this.message.setForeground(Color.white);
            BorderPanel borderPanel2 = new BorderPanel(3, 2);
            borderPanel2.setLayout(new BorderLayout());
            borderPanel2.add(this.message);
            panel.add("Center", borderPanel2);
            if (this.rr.isDirectoryResource()) {
                Button button2 = new Button(REINDEX_L);
                button2.addActionListener(buttonBarListener);
                button2.addMouseListener(mouseButtonListener);
                panel.add("East", button2);
            }
            borderPanel.add("South", panel);
        }
        if (this.rh != null) {
            this.buttonp = new BorderPanel(4, 1);
            this.buttonp.setLayout(new GridLayout(1, this.rh.length + 1));
            this.b = new Button[this.rh.length];
            for (int i = 0; i < this.rh.length; ++i) {
                this.b[i] = new Button(this.rh[i].getTitle());
                this.buttonp.add(this.b[i]);
                this.b[i].addActionListener(buttonBarListener);
                if (!this.rh[i].getTitle().equalsIgnoreCase("shortcut")) continue;
                n = i;
            }
            this.editorp = new Panel(new BorderLayout());
            borderPanel.add("North", this.buttonp);
            borderPanel.add("Center", this.editorp);
            this.target.add("Center", borderPanel);
            this.target.validate();
            this.target.setVisible(true);
            this.switchHelper(this.b[n]);
        } else {
            this.target.add("Center", borderPanel);
            this.target.validate();
            this.target.setVisible(true);
        }
    }

    public ResourceEditor(Panel panel) {
        this.target = panel;
    }

    class MouseButtonListener
    extends MouseAdapter {
        MouseButtonListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof Button) {
                String string = ((Button)component).getActionCommand();
                if (string.equals(ResourceEditor.DELETE_L)) {
                    ResourceEditor.this.setMessage("Delete this resource!");
                } else if (string.equals(ResourceEditor.REINDEX_L)) {
                    ResourceEditor.this.setMessage("Reindex the children.");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ResourceEditor.this.setMessage("");
        }
    }

    class ButtonBarListener
    implements ActionListener {
        ButtonBarListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(ResourceEditor.DELETE_L)) {
                new Deleter().start();
            } else if (actionEvent.getActionCommand().equals(ResourceEditor.REINDEX_L)) {
                ResourceEditor.this.setMessage("Reindexation started...");
                new Reindexer().start();
                ResourceEditor.this.setMessage("Reindexation done.");
            } else {
                new Switcher((Button)actionEvent.getSource()).start();
            }
        }

        class Reindexer
        extends Thread {
            Reindexer() {
            }

            public void run() {
                ResourceEditor.this.reindex();
            }
        }

        class Deleter
        extends Thread {
            Deleter() {
            }

            public void run() {
                ResourceEditor.this.delete();
            }
        }

        class Switcher
        extends Thread {
            Button b;

            public void run() {
                try {
                    ResourceEditor.this.switchHelper(this.b);
                }
                catch (RemoteAccessException remoteAccessException) {
                    // empty catch block
                }
            }

            Switcher(Button button) {
                this.b = button;
            }
        }
    }

    class Alert
    extends Canvas {
        Image alert = null;
        int width = 0;
        int height = 0;

        public Dimension getMinimumSize() {
            return new Dimension(this.width + 8, this.height + 8);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width + 8, this.height + 8);
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            this.initSize();
            Container container = this.getParent();
            if (container != null) {
                container.doLayout();
            }
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }

        private void initSize() {
            if (this.alert != null) {
                this.width = this.alert.getWidth(this);
                this.height = this.alert.getHeight(this);
            }
        }

        public void paint(Graphics graphics) {
            if (this.alert != null) {
                graphics.drawImage(this.alert, 0, 0, this);
            }
        }

        Alert() {
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            String string = propertyManager.getIconLocation("alert");
            if (string != null) {
                this.alert = Toolkit.getDefaultToolkit().getImage(string);
                this.prepareImage(this.alert, this);
            }
            this.initSize();
        }
    }
}

