/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Properties;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadm.editors.EditorFeeder;
import org.w3c.jigadm.editors.EditorModifier;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.ClosableFrame;

public class SelectEditor
extends AttributeEditor {
    public static final String FEEDER_CLASS_P = "feeder.class";
    public static final String MODIFIER_CLASS_P = "modifier.class";
    protected SelectComponent comp = null;
    protected boolean hasChanged = false;
    protected String oldvalue = null;

    protected void createComponent(EditorFeeder editorFeeder, EditorModifier editorModifier, String string) {
        if (this.comp == null) {
            this.comp = new SelectComponent(this, editorFeeder, editorModifier, string);
        }
    }

    protected void setModified() {
        this.hasChanged = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void clearChanged() {
        this.hasChanged = false;
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.comp.setText(this.oldvalue);
    }

    public Object getValue() {
        try {
            return this.comp.getText();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setValue(Object object) {
        this.oldvalue = (String)object;
        this.comp.setText(this.oldvalue);
    }

    public Component getComponent() {
        return this.comp;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        Object object2;
        Object object3;
        EditorFeeder editorFeeder = null;
        EditorModifier editorModifier = null;
        String string = null;
        string = (String)properties.get(FEEDER_CLASS_P);
        if (string == null) {
            throw new RuntimeException("SelectEditor mis-configuration: feeder.class property undefined.");
        }
        try {
            object3 = Class.forName(string);
            editorFeeder = (EditorFeeder)((Class)object3).newInstance();
            editorFeeder.initialize(remoteResourceWrapper, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("SelectEditor mis-configured:  unable to instantiate " + string + ".");
        }
        object3 = (String)properties.get(MODIFIER_CLASS_P);
        if (object3 != null) {
            try {
                object2 = Class.forName((String)object3);
                editorModifier = (EditorModifier)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("SelectEditor mis-configured:  unable to instantiate " + (String)object3 + ".");
            }
        }
        object2 = (String)object;
        this.createComponent(editorFeeder, editorModifier, (String)object2);
        if (object2 != null) {
            this.oldvalue = new String((String)object2);
        }
    }

    class SelectComponent
    extends Panel
    implements ActionListener,
    TextListener {
        protected TextField selected = null;
        protected SelectPopup popup = null;
        protected SelectEditor editor = null;
        EditorFeeder feeder = null;
        EditorModifier modifier = null;

        public void textValueChanged(TextEvent textEvent) {
            SelectEditor.this.setModified();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals("edit")) {
                if (this.popup == null) {
                    this.popup = new SelectPopup(this, this.feeder, this.modifier);
                }
                this.popup.show();
            }
        }

        public String getText() {
            return this.selected.getText();
        }

        public void setText(String string) {
            this.selected.setText(string);
            this.editor.setModified();
        }

        SelectComponent(SelectEditor selectEditor2, EditorFeeder editorFeeder, EditorModifier editorModifier, String string) {
            this.feeder = editorFeeder;
            this.modifier = editorModifier;
            this.editor = selectEditor2;
            this.selected = new TextField(20);
            this.selected.setText(string);
            this.selected.addTextListener(this);
            Button button = new Button("Change");
            button.setActionCommand("edit");
            button.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.selected, "West");
            this.add((Component)button, "Center");
        }
    }

    class SelectPopup
    extends ClosableFrame
    implements ItemListener {
        SelectComponent parent = null;
        List list = null;
        EditorFeeder feeder = null;
        EditorModifier modifier = null;

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = this.list.getItem((Integer)itemEvent.getItem());
                if (this.modifier != null) {
                    string = this.modifier.modify(string);
                }
                this.parent.setText(string);
                this.setVisible(false);
            }
        }

        protected void setDefaultItems() {
            this.list.removeAll();
            String[] stringArray = this.feeder.getDefaultItems();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.list.addItem(stringArray[i]);
                }
            }
        }

        protected void close() {
            this.setVisible(false);
        }

        SelectPopup(SelectComponent selectComponent, EditorFeeder editorFeeder, EditorModifier editorModifier) {
            super("Select");
            this.parent = selectComponent;
            this.feeder = editorFeeder;
            this.modifier = editorModifier;
            this.setLayout(new BorderLayout());
            this.list = new List(20);
            this.list.addItemListener(this);
            this.setDefaultItems();
            this.add(this.list);
            this.setSize(170, 300);
        }
    }
}

