/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.offline.browse;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;

public class ResourceLister {
    protected static Perl5Matcher pmatcher = new Perl5Matcher();
    protected static Perl5Compiler pcompiler = new Perl5Compiler();
    protected static Perl5Util putil = new Perl5Util();
    protected static Pattern srPattern;

    public void printAttributeHolder(AttributeHolder attributeHolder) {
        Attribute[] attributeArray = attributeHolder.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            Object object = attributeHolder.getValue(i, null);
            this.printAttribute(attributeArray[i], object);
        }
    }

    private void printAttribute(Attribute attribute, Object object) {
        System.out.println(this.attributeToString(attribute, object));
    }

    public String attributeToString(Attribute attribute, Object object) {
        String string = attribute.getName() + "=" + object;
        return string;
    }

    public void printFrames(AttributeHolder attributeHolder) {
        AttributeHolder[] attributeHolderArray = this.getFramesFromHolder(attributeHolder);
        for (int i = 0; i < attributeHolderArray.length; ++i) {
            System.out.println("resource frame: ");
            this.printAttributeHolder(attributeHolderArray[i]);
        }
    }

    private Object searchValue(AttributeHolder attributeHolder, String string) {
        Attribute[] attributeArray = attributeHolder.getAttributes();
        Object object = null;
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getName().compareTo(string) != 0) continue;
            object = attributeHolder.getValue(i, null);
        }
        return object;
    }

    public Integer getKeyFromHolder(AttributeHolder attributeHolder) {
        return (Integer)this.searchValue(attributeHolder, "key");
    }

    public String getIdentFromHolder(AttributeHolder attributeHolder) {
        return (String)this.searchValue(attributeHolder, "identifier");
    }

    public String getRepositoryFromHolder(AttributeHolder attributeHolder) {
        return (String)this.searchValue(attributeHolder, "repository");
    }

    public AttributeHolder[] getFramesFromHolder(AttributeHolder attributeHolder) {
        return (AttributeHolder[])this.searchValue(attributeHolder, "frames");
    }

    public void performActionOnFrames(String string, AttributeHolder attributeHolder, int n) {
        AttributeHolder[] attributeHolderArray = this.getFramesFromHolder(attributeHolder);
        for (int i = 0; i < attributeHolderArray.length; ++i) {
            this.performAction(string, attributeHolderArray[i], n + 1);
        }
    }

    public void performAction(String string, AttributeHolder attributeHolder, int n) {
        if (string.compareTo("list") == 0) {
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "\t";
            }
            System.out.println(string2 + "|-" + this.getIdentFromHolder(attributeHolder));
        } else if (string.compareTo("listatt") == 0) {
            this.printAttributeHolder(attributeHolder);
        } else if (pmatcher.matches(string, srPattern)) {
            System.out.println("hop: " + pmatcher.getMatch().group(1));
            Attribute[] attributeArray = attributeHolder.getAttributes();
            try {
                Pattern pattern = pcompiler.compile(pmatcher.getMatch().group(1), 0);
                String string3 = pmatcher.getMatch().group(2);
                for (int i = 0; i < attributeArray.length; ++i) {
                    Object object = attributeHolder.getValue(i, null);
                    String string4 = this.attributeToString(attributeArray[i], object);
                    if (!pmatcher.matches(string4, pattern)) continue;
                    String string5 = putil.substitute(string, string4);
                    System.out.println("replaced: " + string4 + " by: " + string5);
                    attributeHolder.setValue(i, (Object)string3);
                }
            }
            catch (MalformedPatternException malformedPatternException) {
                malformedPatternException.printStackTrace();
            }
        }
    }

    public ResourceLister() {
        try {
            srPattern = pcompiler.compile("^s/(.*[^\\\\])/(.*[^\\\\])/$", 0);
        }
        catch (MalformedPatternException malformedPatternException) {
            malformedPatternException.printStackTrace();
        }
    }
}

