/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

class CSSHandler
implements DocumentHandler,
ErrorHandler {
    String path;
    XRefChecker xrefChecker;
    Report report;
    boolean fontFace = false;
    EPUBVersion version;

    public CSSHandler(String path, XRefChecker xrefChecker, Report report, EPUBVersion version) {
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.version = version;
    }

    public void property(String name, LexicalUnit value, boolean arg2) throws CSSException {
        if (name == null) {
            return;
        }
        if (name.equals("src")) {
            if (value != null && value.getLexicalUnitType() == 24) {
                if (value.getStringValue() != null) {
                    String fontMimeType;
                    String uri = value.getStringValue();
                    uri = PathUtil.resolveRelativeReference(this.path, uri, null);
                    this.xrefChecker.registerReference(this.path, -1, -1, uri, 0);
                    if (this.fontFace && this.version == EPUBVersion.VERSION_3 && (fontMimeType = this.xrefChecker.getMimeType(uri)) != null && !OPFChecker30.isBlessedFontType(fontMimeType)) {
                        this.report.error(this.path, -1, -1, "Font-face reference " + uri + "to non-standard font type " + fontMimeType);
                    }
                } else {
                    this.report.error(this.path, -1, -1, Messages.NULL_REF);
                }
            }
        } else if (name.equals("position") && value != null && value.getStringValue() != null && value.getStringValue().equals("fixed")) {
            this.report.error(this.path, -1, -1, "The fixed value of the position property is not part of the EPUB 3 CSS Profile.");
        } else if (name.equals("direction") || name.equals("unicode-bidi")) {
            this.report.error(this.path, -1, -1, "The direction and unicode-bidi properties must not be included in an EPUB Style Sheet.");
        }
    }

    public void comment(String text) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void endFontFace() throws CSSException {
        this.fontFace = false;
    }

    public void endMedia(SACMediaList media) throws CSSException {
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    public void endSelector(SelectorList selectors) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        String ruri = PathUtil.resolveRelativeReference(this.path, uri, null);
        this.xrefChecker.registerReference(this.path, -1, -1, ruri, 0);
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void startFontFace() throws CSSException {
        this.fontFace = true;
    }

    public void startMedia(SACMediaList media) throws CSSException {
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    public void startSelector(SelectorList selectors) throws CSSException {
    }

    public void error(CSSParseException e) throws CSSException {
    }

    public void fatalError(CSSParseException e) throws CSSException {
    }

    public void warning(CSSParseException e) throws CSSException {
    }
}

