/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.MetaUtils;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OPFHandler30
extends OPFHandler {
    HashSet<String> prefixSet = new HashSet();
    boolean reportedUnsupportedXMLVersion = false;
    static String[] predefinedPrefixes = new String[]{"dcterms", "marc", "media", "onix", "xsd"};
    static HashSet<String> metaPropertySet;
    static HashSet<String> itemrefSet;
    static HashSet<String> linkRelSet;
    static HashSet<String> itemPropertySet;
    static HashMap<String, String> itemPropertyTypeMap;

    OPFHandler30(OCFPackage ocf, String path, Report report, XRefChecker xrefChecker, XMLParser parser, EPUBVersion version) {
        super(ocf, path, report, xrefChecker, parser, version);
        for (int i = 0; i < predefinedPrefixes.length; ++i) {
            this.prefixSet.add(predefinedPrefixes[i]);
        }
    }

    @Override
    public void startElement() {
        XMLElement e;
        String name;
        super.startElement();
        if (!this.reportedUnsupportedXMLVersion) {
            this.reportedUnsupportedXMLVersion = HandlerUtil.checkXMLVersion(this.parser);
        }
        if ((name = (e = this.parser.getCurrentElement()).getName()).equals("package")) {
            HandlerUtil.processPrefixes(e.getAttribute("prefix"), this.prefixSet, this.report, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber());
        } else if (name.equals("meta")) {
            this.processMeta(e);
        } else if (name.equals("link")) {
            this.processLink(e);
        } else if (name.equals("item")) {
            this.processItemProperties(e.getAttribute("properties"), e.getAttribute("media-type"));
        } else if (name.equals("itemref")) {
            this.processItemrefProperties(e.getAttribute("properties"));
        } else if (name.equals("mediaType")) {
            this.processBinding(e);
        }
    }

    private void processBinding(XMLElement e) {
        String mimeType = e.getAttribute("media-type");
        String handlerId = e.getAttribute("handler");
        if (mimeType == null || handlerId == null) {
            return;
        }
        if (OPFChecker30.isCoreMediaType(mimeType)) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "The media-type " + mimeType + " is a core media type");
            return;
        }
        if (this.xrefChecker != null && this.xrefChecker.getBindingHandlerSrc(mimeType) != null) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "The media-type " + mimeType + " has already been assigned a handler");
            return;
        }
        OPFItem handler = (OPFItem)this.itemMapById.get(handlerId);
        if (handler != null && this.xrefChecker != null) {
            this.xrefChecker.registerBinding(mimeType, handler.path);
        }
    }

    private void processLink(XMLElement e) {
        this.processLinkRel(e.getAttribute("rel"));
        String id = e.getAttribute("id");
        String href = e.getAttribute("href");
        if (href != null && !href.startsWith("http://")) {
            try {
                href = PathUtil.resolveRelativeReference(this.path, href, null);
            }
            catch (IllegalArgumentException ex) {
                this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), ex.getMessage());
                href = null;
            }
        }
        String mimeType = e.getAttribute("media-type");
        OPFItem item = new OPFItem(id, href, mimeType, "", "", "", null, this.parser.getLineNumber(), this.parser.getColumnNumber());
        if (id != null) {
            this.itemMapById.put(id, item);
        }
        if (href != null && !href.startsWith("http://")) {
            this.itemMapByPath.put(href, item);
            this.items.add(item);
        }
    }

    private void processItemrefProperties(String property) {
        if (property == null) {
            return;
        }
        int propertiesNumber = MetaUtils.validateProperties(property, itemrefSet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false).size();
        if (propertiesNumber == 2) {
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "itemref can't have both page-spread-right and page-spread-left properties");
        }
    }

    private void processItemProperties(String property, String mimeType) {
        if (property == null) {
            return;
        }
        Set<String> properties = MetaUtils.validateProperties(property, itemPropertySet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false);
        mimeType = mimeType.trim();
        Iterator<String> it = properties.iterator();
        while (it.hasNext()) {
            boolean match = false;
            String propertyValue = it.next();
            String expectedType = itemPropertyTypeMap.get(propertyValue);
            String[] expectedTypeArray = expectedType.split(" ");
            for (int j = 0; j < expectedTypeArray.length; ++j) {
                if (!expectedTypeArray[j].equals(mimeType)) continue;
                match = true;
                break;
            }
            if (match) continue;
            this.report.error(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), "Item property: " + propertyValue + " is not defined for media type: " + mimeType);
        }
    }

    private void processLinkRel(String rel) {
        if (rel == null) {
            return;
        }
        MetaUtils.validateProperties(rel, linkRelSet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, false);
    }

    private void processMeta(XMLElement e) {
        this.processMetaProperty(e.getAttribute("property"));
        this.processMetaScheme(e.getAttribute("scheme"));
    }

    private void processMetaScheme(String scheme) {
        if (scheme == null) {
            return;
        }
        MetaUtils.validateProperties(scheme, null, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, true);
    }

    private void processMetaProperty(String property) {
        if (property == null) {
            return;
        }
        MetaUtils.validateProperties(property, metaPropertySet, this.prefixSet, this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), this.report, true);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("alternate-script");
        set.add("display-seq");
        set.add("file-as");
        set.add("group-position");
        set.add("identifier-type");
        set.add("meta-auth");
        set.add("role");
        set.add("title-type");
        metaPropertySet = set;
        set = new HashSet();
        set.add("page-spread-right");
        set.add("page-spread-left");
        itemrefSet = set;
        set = new HashSet();
        set.add("marc21xml-record");
        set.add("mods-record");
        set.add("onix-record");
        set.add("xml-signature");
        set.add("xmp-record");
        linkRelSet = set;
        set = new HashSet();
        set.add("cover-image");
        set.add("mathml");
        set.add("nav");
        set.add("remote-resources");
        set.add("scripted");
        set.add("svg");
        set.add("switch");
        itemPropertySet = set;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cover-image", "image/gif image/jpeg image/png image/svg+xml");
        map.put("mathml", "application/xhtml+xml image/svg+xml");
        map.put("nav", "application/xhtml+xml");
        map.put("remote-resources", "application/xhtml+xml image/svg+xml text/css");
        map.put("scripted", "application/xhtml+xml image/svg+xml");
        map.put("svg", "application/xhtml+xml");
        map.put("switch", "application/xhtml+xml image/svg+xml");
        itemPropertyTypeMap = map;
    }
}

