/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization;

import java.util.Vector;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.serialization.AttributeDescription;

public class ResourceDescription {
    String classname = null;
    String[] classes = null;
    String[] interfaces = null;
    String identifier = null;
    AttributeDescription[] attributes = null;
    String[] children = null;

    public ResourceDescription getClone(AttributeDescription[] attributeDescriptionArray) {
        ResourceDescription resourceDescription = new ResourceDescription(this.classname);
        resourceDescription.identifier = this.identifier;
        resourceDescription.children = this.children;
        resourceDescription.attributes = attributeDescriptionArray;
        resourceDescription.classes = this.classes;
        resourceDescription.interfaces = this.interfaces;
        return resourceDescription;
    }

    public String[] getClassHierarchy() {
        return this.classes;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getClassesAndInterfaces() {
        String[] stringArray = new String[this.interfaces.length + this.classes.length];
        System.arraycopy(this.classes, 0, stringArray, 0, this.classes.length);
        System.arraycopy(this.interfaces, 0, stringArray, this.classes.length, this.interfaces.length);
        return stringArray;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getIdentifier() {
        if (this.identifier == null && this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (!this.attributes[i].getName().equals("identifier")) continue;
                this.identifier = (String)this.attributes[i].getValue();
            }
        }
        return this.identifier;
    }

    public String[] getChildren() {
        return this.children;
    }

    public void setChildren(String[] stringArray) {
        this.children = stringArray;
    }

    public AttributeDescription[] getAttributeDescriptions() {
        return this.attributes;
    }

    public ResourceDescription[] getFrameDescriptions() {
        for (int i = 0; i < this.attributes.length; ++i) {
            Object object = this.attributes[i].getValue();
            if (!(object instanceof ResourceDescription[])) continue;
            return (ResourceDescription[])object;
        }
        return new ResourceDescription[0];
    }

    public ResourceDescription(Resource resource) {
        Attribute[] attributeArray;
        this.classname = resource.getClass().getName();
        Vector<String> vector = new Vector<String>(8);
        Vector vector2 = new Vector(8);
        Class<?>[] classArray = resource.getClass().getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                vector2.addElement(classArray[i]);
            }
        }
        for (attributeArray = resource.getClass().getSuperclass(); attributeArray != null; attributeArray = attributeArray.getSuperclass()) {
            vector.addElement(attributeArray.getName());
            classArray = attributeArray.getInterfaces();
            if (classArray == null) continue;
            for (int i = 0; i < classArray.length; ++i) {
                vector2.addElement(classArray[i]);
            }
        }
        this.classes = new String[vector.size()];
        vector.copyInto(this.classes);
        this.interfaces = new String[vector2.size()];
        vector2.copyInto(this.interfaces);
        attributeArray = resource.getAttributes();
        Vector<AttributeDescription> vector3 = new Vector<AttributeDescription>(10);
        for (int i = 0; i < attributeArray.length; ++i) {
            Object object = resource.getValue(i, null);
            if (object instanceof ResourceFrame[]) {
                ResourceFrame[] resourceFrameArray = (ResourceFrame[])object;
                int n = resourceFrameArray.length;
                ResourceDescription[] resourceDescriptionArray = new ResourceDescription[n];
                for (int j = 0; j < n; ++j) {
                    resourceDescriptionArray[j] = new ResourceDescription(resourceFrameArray[j]);
                }
                vector3.addElement(new AttributeDescription(attributeArray[i], resourceDescriptionArray));
                continue;
            }
            vector3.addElement(new AttributeDescription(attributeArray[i], object));
        }
        this.attributes = new AttributeDescription[vector3.size()];
        vector3.copyInto(this.attributes);
    }

    public void setAttributeDescriptions(Vector vector) {
        this.attributes = new AttributeDescription[vector.size()];
        vector.copyInto(this.attributes);
    }

    public void setClassHierarchy(String[] stringArray) {
        this.classes = stringArray;
    }

    public void setInterfaces(String[] stringArray) {
        this.interfaces = stringArray;
    }

    public void setClassHierarchy(Vector vector) {
        this.classes = new String[vector.size()];
        vector.copyInto(this.classes);
    }

    public void setInterfaces(Vector vector) {
        this.interfaces = new String[vector.size()];
        vector.copyInto(this.interfaces);
    }

    public ResourceDescription(String string) {
        this.classname = string;
        this.interfaces = new String[0];
        this.classes = new String[0];
    }
}

