/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader;

import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.streamprovider.StringInputStreamProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.handler.CSSHandler;
import com.phloc.css.handler.DoNothingCSSParseExceptionHandler;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.CharStream;
import com.phloc.css.parser.JavaCharStream;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.ParseUtils;
import com.phloc.css.parser.ParserCSS21;
import com.phloc.css.parser.ParserCSS21TokenManager;
import com.phloc.css.parser.ParserCSS30;
import com.phloc.css.parser.ParserCSS30TokenManager;
import com.phloc.css.parser.ParserCSSCharsetDetector;
import com.phloc.css.parser.ParserCSSCharsetDetectorTokenManager;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReader.class);

    private CSSReader() {
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream aStream, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        switch (eVersion) {
            case CSS21: {
                ParserCSS21TokenManager aTokenHdl = new ParserCSS21TokenManager(aStream);
                ParserCSS21 aParser = new ParserCSS21(aTokenHdl);
                try {
                    return aParser.styleSheet();
                }
                catch (ParseException ex) {
                    if (aCustomExceptionHandler != null) {
                        aCustomExceptionHandler.onException(ex);
                    } else {
                        s_aLogger.error("Failed to parse CSS 2.1 style sheet: " + ex.getMessage());
                    }
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager aTokenHdl = new ParserCSS30TokenManager(aStream);
                ParserCSS30 aParser = new ParserCSS30(aTokenHdl);
                try {
                    return aParser.styleSheet();
                }
                catch (ParseException ex) {
                    if (aCustomExceptionHandler != null) {
                        aCustomExceptionHandler.onException(ex);
                    } else {
                        s_aLogger.error("Failed to parse CSS 3.0 style sheet: " + ex.getMessage());
                    }
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eVersion));
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(aFile), sCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(aFile), aCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        if (aCharset == null) {
            throw new IllegalArgumentException("Illegal charset '" + sCharset + "'");
        }
        return CSSReader.isValidCSS(aRes, aCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        if (aRes == null) {
            throw new NullPointerException("resources");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        Reader aReader = aRes.getReader(aCharset);
        if (aReader == null) {
            s_aLogger.warn("Failed to open CSS reader " + aRes);
            return false;
        }
        return CSSReader.isValidCSS(aReader, eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        if (sCharset == null) {
            throw new NullPointerException("charset");
        }
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)aIS, (String)sCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)aIS, (Charset)aCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        if (sCSS == null) {
            throw new NullPointerException("reader");
        }
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(sCSS), eVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        if (aReader == null) {
            throw new NullPointerException("reader");
        }
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        try {
            JavaCharStream aCharStream = new JavaCharStream(aReader);
            CSSNode aNode = CSSReader._readStyleSheet(aCharStream, eVersion, new DoNothingCSSParseExceptionHandler());
            boolean bl = aNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromString(sCSS, sCharset, eVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromString(sCSS, aCharset, eVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(sCSS, sCharset), sCharset, eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(sCSS, aCharset), aCharset, eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromFile(aFile, sCharset, eVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromFile(aFile, aCharset, eVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(aFile), sCharset, eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(aFile), aCharset, eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStream(aISP, sCharset, eVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStream(aISP, aCharset, eVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        if (aCharset == null) {
            throw new IllegalArgumentException("Failed to resolve charset '" + sCharset + "'");
        }
        return CSSReader.readFromStream(aISP, aCharset, eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IInputStreamProvider aISP) {
        if (aISP == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        try {
            JavaCharStream aCharStream = new JavaCharStream(aIS, CCharset.CHARSET_ISO_8859_1_OBJ);
            ParserCSSCharsetDetectorTokenManager aTokenHdl = new ParserCSSCharsetDetectorTokenManager(aCharStream);
            ParserCSSCharsetDetector aParser = new ParserCSSCharsetDetector(aTokenHdl);
            String sCharsetName = aParser.styleSheetCharset().getText();
            if (sCharsetName == null) {
                Charset charset = null;
                return charset;
            }
            Charset charset = CharsetManager.getCharsetFromName((String)ParseUtils.extractStringValue(sCharsetName));
            return charset;
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Failed to parse CSS charset definition", ex);
        }
        finally {
            StreamUtils.close((Closeable)aIS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        InputStream aIS;
        if (aISP == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        Charset aCharsetToUse = aCharset;
        Charset aDeclaredCharset = CSSReader.getCharsetDeclaredInCSS(aISP);
        if (aDeclaredCharset != null) {
            s_aLogger.info("Reading CSS definition again with explicit charset '" + aDeclaredCharset.name() + "'");
            aCharsetToUse = aDeclaredCharset;
        }
        if ((aIS = aISP.getInputStream()) == null) {
            return null;
        }
        try {
            JavaCharStream aCharStream = new JavaCharStream(aIS, aCharsetToUse);
            CSSNode aNode = CSSReader._readStyleSheet(aCharStream, eVersion, aCustomExceptionHandler);
            if (aNode == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eVersion, aNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamUtils.close((Closeable)aIS);
        }
    }
}

