/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutable;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableBoolean
implements IMutable<MutableBoolean> {
    public static final boolean DEFAULT_VALUE = false;
    private boolean m_bValue;

    public MutableBoolean() {
        this(false);
    }

    public MutableBoolean(@Nonnull Boolean aValue) {
        this((boolean)aValue);
    }

    public MutableBoolean(boolean bValue) {
        this.m_bValue = bValue;
    }

    public boolean booleanValue() {
        return this.m_bValue;
    }

    @Nonnull
    public Boolean getAsBoolean() {
        return this.m_bValue;
    }

    @Nonnull
    public EChange set(boolean bValue) {
        if (this.m_bValue == bValue) {
            return EChange.UNCHANGED;
        }
        this.m_bValue = bValue;
        return EChange.CHANGED;
    }

    @Override
    public int compareTo(@Nonnull MutableBoolean rhs) {
        return this.m_bValue == rhs.m_bValue ? 0 : (this.m_bValue ? -1 : 1);
    }

    @Override
    @Nonnull
    public MutableBoolean getClone() {
        return new MutableBoolean(this.m_bValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableBoolean)) {
            return false;
        }
        MutableBoolean rhs = (MutableBoolean)o;
        return this.m_bValue == rhs.m_bValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_bValue).toString();
    }
}

