/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.xpath;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public final class XPathHelper {
    private static final XPathFactory s_aXPathFactory = XPathFactory.newInstance();

    private XPathHelper() {
    }

    @Nonnull
    public static XPath createNewXPath() {
        return XPathHelper.createNewXPath(null, null, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathVariableResolver aVariableResolver) {
        return XPathHelper.createNewXPath(aVariableResolver, null, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathFunctionResolver aFunctionResolver) {
        return XPathHelper.createNewXPath(null, aFunctionResolver, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable NamespaceContext aNamespaceContext) {
        return XPathHelper.createNewXPath(null, null, aNamespaceContext);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext) {
        XPath aXPath = s_aXPathFactory.newXPath();
        if (aVariableResolver != null) {
            aXPath.setXPathVariableResolver(aVariableResolver);
        }
        if (aFunctionResolver != null) {
            aXPath.setXPathFunctionResolver(aFunctionResolver);
        }
        if (aNamespaceContext != null) {
            aXPath.setNamespaceContext(aNamespaceContext);
        }
        return aXPath;
    }

    @Nonnull
    public static XPathExpression createNewXPathExpresion(@Nullable XPathVariableResolver aVariableResolver, @Nullable XPathFunctionResolver aFunctionResolver, @Nullable NamespaceContext aNamespaceContext, @Nonnull @Nonempty String sXPath) {
        return XPathHelper.createNewXPathExpresion(XPathHelper.createNewXPath(aVariableResolver, aFunctionResolver, aNamespaceContext), sXPath);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpresion(@Nullable XPathVariableResolver aVariableResolver, @Nonnull @Nonempty String sXPath) {
        return XPathHelper.createNewXPathExpresion(XPathHelper.createNewXPath(aVariableResolver), sXPath);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpresion(@Nullable XPathFunctionResolver aFunctionResolver, @Nonnull @Nonempty String sXPath) {
        return XPathHelper.createNewXPathExpresion(XPathHelper.createNewXPath(aFunctionResolver), sXPath);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpresion(@Nullable NamespaceContext aNamespaceContext, @Nonnull @Nonempty String sXPath) {
        return XPathHelper.createNewXPathExpresion(XPathHelper.createNewXPath(aNamespaceContext), sXPath);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpresion(@Nonnull @Nonempty String sXPath) {
        return XPathHelper.createNewXPathExpresion(XPathHelper.createNewXPath(), sXPath);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpresion(@Nonnull XPath aXPath, @Nonnull @Nonempty String sXPath) {
        if (aXPath == null) {
            throw new NullPointerException("XPath");
        }
        if (StringHelper.hasNoText(sXPath)) {
            throw new IllegalArgumentException("XPath");
        }
        try {
            return aXPath.compile(sXPath);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Failed to compile XPath expression '" + sXPath + "'", ex);
        }
    }
}

