/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.proxy.ForwardFrame;
import org.w3c.jigsaw.resources.VirtualHostResource;
import org.w3c.jigsaw.servlet.AutoReloadServletLoader;
import org.w3c.jigsaw.servlet.JigsawRequestDispatcher;
import org.w3c.jigsaw.servlet.ServletDirectoryFrame;
import org.w3c.jigsaw.servlet.ServletProps;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.tools.resources.event.StructureChangedAdapter;
import org.w3c.tools.resources.event.StructureChangedEvent;
import org.w3c.util.EmptyEnumeration;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.www.mime.Utils;

public class JigsawServletContext
extends StructureChangedAdapter
implements ServletContext,
PropertyMonitoring {
    public static final String TEMPDIR_P = "javax.servlet.context.tempdir";
    private ResourceReference reference = null;
    private Logger logger = null;
    private ObservableProperties props = null;
    private File directory = null;
    private Hashtable attributes = null;
    protected static String logdir = "logs";
    protected static String deflogfile = "servlets";
    private AutoReloadServletLoader loader = null;

    public boolean propertyChanged(String string) {
        if (string.equals(ServletProps.SERVLET_LOG_FILE_P) && this.logger != null) {
            this.logger.close();
            File file = new File((String)this.props.get(ServletProps.SERVLET_LOG_FILE_P));
            if (file.getPath().length() < 1) {
                file = this.getServletLogFile();
            }
            this.logger = new Logger(file);
        }
        return true;
    }

    public void resourceUnloaded(StructureChangedEvent structureChangedEvent) {
        if (this.logger != null) {
            this.logger.close();
        }
    }

    protected long getServletTimeout() {
        return this.props.getLong(ServletProps.SERVLET_TIMEOUT, -1L);
    }

    protected int getServletInstanceMax() {
        return this.props.getInteger(ServletProps.SERVLET_INSTANCEMAX, 0);
    }

    protected static String guessContentTypeFromName(String string) {
        return Utils.guessContentTypeFromName(string);
    }

    public String getMimeType(String string) {
        return JigsawServletContext.guessContentTypeFromName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInterface getServer() {
        try {
            Resource resource = this.reference.lock();
            ServerInterface serverInterface = ((ServletDirectoryFrame)resource).getServer();
            return serverInterface;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            ServerInterface serverInterface = null;
            return serverInterface;
        }
        finally {
            this.reference.unlock();
        }
    }

    public File getServletLogFile() {
        ServerInterface serverInterface = this.getServer();
        File file = null;
        String string = serverInterface.getProperties().getString(ServletProps.SERVLET_LOG_FILE_P, null);
        if (string != null) {
            file = new File(string);
        }
        if (file != null && file.getPath().length() < 1) {
            file = null;
        }
        if (file == null) {
            File file2 = serverInterface.getRootDirectory();
            if (file2 == null) {
                throw new RuntimeException("unable to build a default value for the servlet log file.");
            }
            file = new File(new File(file2, logdir), deflogfile);
            serverInterface.getProperties().putValue(ServletProps.SERVLET_LOG_FILE_P, file.getAbsolutePath());
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet(String string) {
        try {
            Resource resource = this.reference.lock();
            Servlet servlet = ((ServletDirectoryFrame)resource).getServlet(string);
            return servlet;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            Servlet servlet = null;
            return servlet;
        }
        finally {
            this.reference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getServlets() {
        try {
            Resource resource = this.reference.lock();
            Enumeration enumeration = ((ServletDirectoryFrame)resource).getServlets();
            return enumeration;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            Enumeration enumeration = null;
            return enumeration;
        }
        finally {
            this.reference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getServletNames() {
        try {
            Resource resource = this.reference.lock();
            Enumeration enumeration = ((ServletDirectoryFrame)resource).getServletNames();
            return enumeration;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            Enumeration enumeration = null;
            return enumeration;
        }
        finally {
            this.reference.unlock();
        }
    }

    public void log(String string) {
        this.logger.log(string);
    }

    public void log(Exception exception, String string) {
        this.logger.log(exception, string);
    }

    public void log(String string, Throwable throwable) {
        this.logger.log(throwable, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getRealPath(String string, ResourceReference resourceReference, ResourceReference resourceReference2) {
        LookupState lookupState;
        ResourceReference resourceReference3 = JigsawServletContext.getLocalRoot(resourceReference, resourceReference2);
        try {
            ResourceReference resourceReference4;
            block15: {
                FramedResource framedResource = (FramedResource)resourceReference3.lock();
                lookupState = new LookupState(string);
                LookupResult lookupResult = new LookupResult(resourceReference3);
                if (framedResource.lookup(lookupState, lookupResult) && (resourceReference4 = lookupResult.getTarget()) != null) {
                    FramedResource framedResource2 = (FramedResource)resourceReference4.lock();
                    if (framedResource2 instanceof FileResource) {
                        File file = ((FileResource)framedResource2).getFile();
                        String string2 = file.getAbsolutePath();
                        return string2;
                    }
                    if (!(framedResource2 instanceof DirectoryResource)) break block15;
                    DirectoryResource directoryResource = (DirectoryResource)framedResource2;
                    String string3 = directoryResource.getDirectory().getAbsolutePath();
                    return string3;
                    finally {
                        resourceReference4.unlock();
                    }
                }
            }
            resourceReference4 = null;
            return resourceReference4;
        }
        catch (InvalidResourceException invalidResourceException) {
            lookupState = null;
            return lookupState;
        }
        catch (ProtocolException protocolException) {
            lookupState = null;
            return lookupState;
        }
        finally {
            resourceReference3.unlock();
        }
    }

    public Set getResourcePaths(String string) {
        return null;
    }

    public String getServletContextName() {
        return null;
    }

    public String getRealPath(String string) {
        ResourceReference resourceReference = ((httpd)this.getServer()).getRootReference();
        return JigsawServletContext.getRealPath(string, resourceReference, this.reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getFilePath(DirectoryResource directoryResource) {
        HTTPFrame hTTPFrame = (HTTPFrame)directoryResource.getFrame("org.w3c.jigsaw.frames.HTTPFrame");
        String[] stringArray = hTTPFrame.getIndexes();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ResourceReference resourceReference;
                String string = stringArray[i];
                if (string == null || string.length() <= 0 || (resourceReference = directoryResource.lookup(string)) == null) continue;
                try {
                    FramedResource framedResource = (FramedResource)resourceReference.lock();
                    if (framedResource instanceof FileResource) {
                        FileResource fileResource = (FileResource)framedResource;
                        File file = fileResource.getFile();
                        String string2 = file.getAbsolutePath();
                        return string2;
                    }
                    String string3 = null;
                    return string3;
                }
                catch (InvalidResourceException invalidResourceException) {
                    continue;
                }
                finally {
                    resourceReference.unlock();
                }
            }
            return directoryResource.getDirectory().getAbsolutePath();
        }
        return directoryResource.getDirectory().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ResourceReference getLocalRoot(ResourceReference resourceReference, ResourceReference resourceReference2) {
        Object object;
        FramedResource framedResource;
        ResourceReference resourceReference3;
        Object object2;
        block28: {
            FramedResource framedResource2 = (FramedResource)resourceReference.lock();
            if (framedResource2 instanceof VirtualHostResource) {
                object2 = null;
                resourceReference3 = null;
                framedResource = null;
                try {
                    framedResource = (FramedResource)resourceReference2.lock();
                    if (framedResource instanceof ResourceFrame) {
                        object = (ResourceFrame)framedResource;
                        object2 = ((ResourceFrame)object).getResource().getResourceReference();
                        break block28;
                    } else {
                        object2 = resourceReference2;
                    }
                    break block28;
                }
                catch (InvalidResourceException invalidResourceException) {
                    ResourceReference resourceReference4 = resourceReference;
                    resourceReference.unlock();
                    return resourceReference4;
                }
                finally {
                    resourceReference2.unlock();
                }
            }
            object2 = (FramedResource)resourceReference.lock();
            ForwardFrame forwardFrame = (ForwardFrame)((FramedResource)object2).getFrame("org.w3c.jigsaw.proxy.ForwardFrame");
            if (forwardFrame == null) {
                ResourceReference resourceReference5 = resourceReference;
                return resourceReference5;
            }
            ResourceReference resourceReference6 = forwardFrame.getLocalRootResource();
            catch (InvalidResourceException invalidResourceException) {
                return resourceReference;
            }
            {
                ResourceReference resourceReference7 = JigsawServletContext.getLocalRoot(resourceReference6, resourceReference2);
                return resourceReference7;
            }
            catch (InvalidResourceException invalidResourceException) {
                object2 = resourceReference;
                return object2;
            }
            finally {
                resourceReference.unlock();
            }
        }
        while (true) {
            try {
                framedResource = (FramedResource)object2.lock();
                resourceReference3 = framedResource.getParent();
                if (resourceReference3 == resourceReference || resourceReference3 == null) {
                    object = JigsawServletContext.getLocalRoot((ResourceReference)object2, resourceReference2);
                    return object;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
                ResourceReference resourceReference8 = resourceReference;
                return resourceReference8;
            }
            object2 = resourceReference3;
        }
        finally {
            object2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerInfo() {
        try {
            Resource resource = this.reference.lock();
            String string = ((ServletDirectoryFrame)resource).getServerInfo();
            return string;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.reference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        Object v = this.attributes.get(string);
        if (v != null) {
            return v;
        }
        try {
            Resource resource = this.reference.lock();
            Object object = ((ServletDirectoryFrame)resource).getAttribute(string);
            return object;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            this.reference.unlock();
        }
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new EmptyEnumeration();
    }

    protected synchronized AutoReloadServletLoader getLocalServletLoader() {
        if (this.loader == null) {
            this.loader = new AutoReloadServletLoader(this);
        }
        return this.loader;
    }

    protected synchronized AutoReloadServletLoader createNewLocalServletLoader(boolean bl) {
        this.loader = this.loader != null && bl ? new AutoReloadServletLoader(this.loader) : new AutoReloadServletLoader(this);
        return this.loader;
    }

    public File getServletDirectory() {
        return this.directory;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return JigsawRequestDispatcher.getRequestDispatcher(string, (httpd)this.getServer(), this.reference);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        return JigsawRequestDispatcher.getRequestDispatcher(string, this.reference, (httpd)this.getServer());
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletContext getContext(String string) {
        Object object;
        Object object2;
        if (string == null) {
            return null;
        }
        ResourceReference resourceReference = null;
        resourceReference = ((httpd)this.getServer()).getRootReference();
        FramedResource framedResource = null;
        framedResource = ((httpd)this.getServer()).getRoot();
        ResourceReference resourceReference2 = null;
        try {
            object2 = new LookupState(string);
            object = new LookupResult(resourceReference);
            framedResource.lookup((LookupState)object2, (LookupResult)object);
            resourceReference2 = ((LookupResult)object).getTarget();
        }
        catch (Exception exception) {
            resourceReference2 = null;
        }
        if (resourceReference2 != null) {
            try {
                object2 = resourceReference2.lock();
                if (object2 instanceof FramedResource && (object = (ServletDirectoryFrame)((FramedResource)object2).getFrame("org.w3c.jigsaw.servlet.ServletDirectoryFrame")) != null) {
                    ServletContext servletContext = ((ServletDirectoryFrame)object).getServletContext();
                    return servletContext;
                }
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                resourceReference2.unlock();
            }
        }
        return null;
    }

    public URL getResource(String string) throws MalformedURLException {
        File file = new File(string);
        if (file.exists()) {
            return new URL("file", "", file.getAbsolutePath());
        }
        String string2 = this.getRealPath(string);
        if (string2 != null) {
            file = new File(string2);
            if (file.exists()) {
                return new URL("file", "", file.getAbsolutePath());
            }
            return null;
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            try {
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected JigsawServletContext(ResourceReference resourceReference, ObservableProperties observableProperties) {
        this.reference = resourceReference;
        this.props = observableProperties;
        this.attributes = new Hashtable(3);
        this.logger = new Logger(this.getServletLogFile());
        this.loader = new AutoReloadServletLoader(this);
        observableProperties.registerObserver(this);
        try {
            Resource resource = this.reference.lock();
            if (!(resource instanceof ServletDirectoryFrame)) {
                throw new IllegalArgumentException("This reference is not pointing on a ServletDirectoryFrame.");
            }
            ServletDirectoryFrame servletDirectoryFrame = (ServletDirectoryFrame)resource;
            FramedResource framedResource = servletDirectoryFrame.getResource();
            framedResource.addStructureChangedListener(this);
            if (framedResource.definesAttribute("directory")) {
                this.directory = (File)framedResource.getValue("directory", null);
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            throw new IllegalArgumentException("This reference is pointing on an Invalid ServletDirectoryFrame.");
        }
        finally {
            this.reference.unlock();
        }
    }

    class Logger {
        File logfile = null;
        RandomAccessFile log = null;
        byte[] msgbuf = null;
        boolean closed = true;
        private final String[] monthnames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        String getDate() {
            Date date = new Date();
            return date.getDate() + "/" + this.monthnames[date.getMonth()] + "/" + (date.getYear() + 1900) + (date.getHours() < 10 ? ":0" + date.getHours() : ":" + date.getHours()) + (date.getMinutes() < 10 ? ":0" + date.getMinutes() : ":" + date.getMinutes()) + (date.getSeconds() < 10 ? ":0" + date.getSeconds() : ":" + date.getSeconds()) + (date.getTimezoneOffset() < 0 ? " " + date.getTimezoneOffset() / 60 : " +" + date.getTimezoneOffset() / 60);
        }

        void log(String string) {
            string = "[" + this.getDate() + "] " + string + "\n";
            try {
                if (this.log == null || this.closed) {
                    this.openLogFile();
                }
                if (this.log != null) {
                    int n = string.length();
                    if (n > this.msgbuf.length) {
                        this.msgbuf = new byte[n];
                    }
                    string.getBytes(0, n, this.msgbuf, 0);
                    this.log.write(this.msgbuf, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Can't write (" + string + ") to logfile [" + this.logfile + "] : " + iOException.getMessage());
            }
        }

        void log(Exception exception, String string) {
            this.log(string + " : " + exception.getClass().getName() + " (" + exception.getMessage() + ")");
        }

        void log(Throwable throwable, String string) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            String string2 = byteArrayOutputStream.toString();
            this.log(string + " " + string2);
        }

        void openLogFile() throws IOException {
            RandomAccessFile randomAccessFile = this.log;
            this.log = new RandomAccessFile(this.logfile, "rw");
            this.log.seek(this.log.length());
            this.closed = false;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }

        void close() {
            try {
                if (this.log != null) {
                    this.log.close();
                }
                this.closed = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        Logger(File file) {
            this.logfile = file;
            this.msgbuf = new byte[128];
            this.log("Servlet Logger started");
        }
    }
}

