/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultipartInputStream
extends InputStream {
    InputStream in = null;
    byte[] boundary = null;
    byte[] buffer = null;
    boolean partEnd = false;
    boolean fileEnd = false;

    private final boolean readBoundaryBytes() throws IOException {
        int n;
        for (int i = 0; i < this.buffer.length; i += n) {
            n = this.in.read(this.buffer, i, this.buffer.length - i);
            if (n >= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean skipToBoundary() throws IOException {
        int n = this.in.read();
        block0: while (n != -1) {
            if (n != 45) {
                n = this.in.read();
                continue;
            }
            n = this.in.read();
            if (n != 45) continue;
            this.in.mark(this.boundary.length);
            if (!this.readBoundaryBytes()) {
                this.in.reset();
                n = this.in.read();
                continue;
            }
            for (int i = 0; i < this.boundary.length; ++i) {
                if (this.buffer[i] == this.boundary[i]) continue;
                this.in.reset();
                n = this.in.read();
                continue block0;
            }
            n = this.in.read();
            if (n == 13) {
                n = this.in.read();
            }
            this.in.mark(3);
            if (this.in.read() == 45 && this.in.read() == 13 && this.in.read() == 10) {
                this.fileEnd = true;
                return false;
            }
            this.in.reset();
            return true;
        }
        this.fileEnd = true;
        return false;
    }

    public int read() throws IOException {
        if (this.partEnd) {
            return -1;
        }
        int n = this.in.read();
        switch (n) {
            case 13: {
                this.in.mark(this.boundary.length + 3);
                int n2 = this.in.read();
                int n3 = this.in.read();
                int n4 = this.in.read();
                if (n2 == 10 && n3 == 45 && n4 == 45) {
                    if (!this.readBoundaryBytes()) {
                        this.in.reset();
                        return n;
                    }
                    for (int i = 0; i < this.boundary.length; ++i) {
                        if (this.buffer[i] == this.boundary[i]) continue;
                        this.in.reset();
                        return n;
                    }
                    this.partEnd = true;
                    n = this.in.read();
                    if (n == 13) {
                        this.in.read();
                    } else if (n == 45) {
                        if (this.in.read() == 45) {
                            this.fileEnd = true;
                        }
                    } else {
                        this.fileEnd = n == -1;
                    }
                    return -1;
                }
                this.in.reset();
                return n;
            }
            case -1: {
                this.fileEnd = true;
                return -1;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n + n3++] = (byte)(n4 & 0xFF);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        while (--l >= 0L && this.read() != -1) {
        }
        return l;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public boolean nextInputStream() throws IOException {
        if (this.fileEnd) {
            return false;
        }
        if (!this.partEnd) {
            return this.skipToBoundary();
        }
        this.partEnd = false;
        return true;
    }

    public MultipartInputStream(InputStream inputStream, byte[] byArray) {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, byArray.length + 4);
        this.boundary = byArray;
        this.buffer = new byte[byArray.length];
        this.partEnd = false;
        this.fileEnd = false;
    }
}

