/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.iterate.ArrayIterator;
import com.phloc.commons.collections.iterate.EmptyIterator;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IterableIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private static final IterableIterator<Object> s_aEmpty = new IterableIterator(EmptyIterator.getInstance());
    private final Iterator<ELEMENTTYPE> m_aIter;

    protected IterableIterator(@Nonnull ELEMENTTYPE[] aCont) {
        this(ArrayIterator.create(aCont));
    }

    protected IterableIterator(@Nonnull Iterable<ELEMENTTYPE> aCont) {
        this(aCont.iterator());
    }

    protected IterableIterator(@Nonnull Iterator<ELEMENTTYPE> aIter) {
        if (aIter == null) {
            throw new NullPointerException("iterator");
        }
        this.m_aIter = aIter;
    }

    @Override
    public final boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    @Override
    @Nullable
    public final ELEMENTTYPE next() {
        return this.m_aIter.next();
    }

    @Override
    public final void remove() {
        this.m_aIter.remove();
    }

    @Override
    @Nonnull
    public final Iterator<ELEMENTTYPE> iterator() {
        return this.m_aIter;
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> createEmpty() {
        return (IIterableIterator)GenericReflection.uncheckedCast(s_aEmpty);
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> create(@Nonnull ELEMENTTYPE[] aCont) {
        return new IterableIterator<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> create(@Nonnull Iterable<ELEMENTTYPE> aCont) {
        return new IterableIterator<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> create(@Nonnull Iterator<ELEMENTTYPE> aIter) {
        return new IterableIterator<ELEMENTTYPE>(aIter);
    }
}

