/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.io.IWritableResourceProvider;
import com.phloc.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WritableResourceProviderChain
extends ReadableResourceProviderChain
implements IWritableResourceProvider {
    protected final List<IWritableResourceProvider> m_aWritableResourceProviders = new ArrayList<IWritableResourceProvider>();

    public WritableResourceProviderChain(IReadableResourceProvider ... aResProviders) {
        super(aResProviders);
        for (IReadableResourceProvider aResProvider : aResProviders) {
            if (!(aResProvider instanceof IWritableResourceProvider)) continue;
            this.m_aWritableResourceProviders.add((IWritableResourceProvider)aResProvider);
        }
        if (this.m_aWritableResourceProviders.isEmpty()) {
            throw new IllegalArgumentException("No writable resource provider passed - use a ReadableResourceProviderChain");
        }
    }

    @Override
    public final boolean supportsWriting(@Nullable String sName) {
        for (IWritableResourceProvider aResProvider : this.m_aWritableResourceProviders) {
            if (!aResProvider.supportsWriting(sName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IWritableResource getWritableResource(String sName) {
        for (IWritableResourceProvider aResProvider : this.m_aWritableResourceProviders) {
            if (!aResProvider.supportsWriting(sName)) continue;
            return aResProvider.getWritableResource(sName);
        }
        throw new IllegalArgumentException("Cannot handle writing '" + sName + "' by " + this.m_aReadingResourceProviders);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        WritableResourceProviderChain rhs = (WritableResourceProviderChain)o;
        return ((Object)this.m_aWritableResourceProviders).equals(rhs.m_aWritableResourceProviders);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aWritableResourceProviders)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("writableResProviders", this.m_aWritableResourceProviders).toString();
    }
}

