/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.FilterInterface;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.StringArrayAttribute;

public class RequestedHeaderFilter
extends ResourceFilter {
    protected static int ATTR_HEADER_NAMES = -1;
    protected static int ATTR_SEND_HEADER_LIST = -1;
    private String[] headerNames = null;
    private boolean sendHeaderList = false;

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_HEADER_NAMES) {
            this.headerNames = (String[])object;
        } else if (n == ATTR_SEND_HEADER_LIST) {
            this.sendHeaderList = (Boolean)object;
        }
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.headerNames = (String[])this.getValue(ATTR_HEADER_NAMES, null);
        this.sendHeaderList = this.getBoolean(ATTR_SEND_HEADER_LIST, false);
    }

    protected String[] getHeaderNames() {
        String[] stringArray = (String[])this.getValue(ATTR_HEADER_NAMES, null);
        return stringArray;
    }

    protected boolean getSendHeaderList() {
        return this.getBoolean(ATTR_SEND_HEADER_LIST, false);
    }

    private boolean checkHeaders(Request request) {
        if (this.headerNames != null) {
            int n = this.headerNames.length;
            for (int i = 0; i < n; ++i) {
                if (request.hasHeader(this.headerNames[i])) continue;
                return false;
            }
        }
        return true;
    }

    public ReplyInterface ingoingFilter(RequestInterface requestInterface) throws ProtocolException {
        Request request = (Request)requestInterface;
        Reply reply = null;
        if (this.checkHeaders(request)) {
            return null;
        }
        reply = request.makeReply(403);
        HtmlGenerator htmlGenerator = new HtmlGenerator("Forbidden - Headers missing");
        htmlGenerator.append("Some Headers, mandatory for this resource, are missing.");
        if (this.sendHeaderList && this.headerNames != null) {
            htmlGenerator.append("<ul>");
            for (int i = 0; i < this.headerNames.length; ++i) {
                htmlGenerator.append("<li>");
                htmlGenerator.appendAndEscape(this.headerNames[i]);
                htmlGenerator.append("</li>");
            }
            htmlGenerator.append("</ul>");
        }
        reply.setStream(htmlGenerator);
        return reply;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws ProtocolException {
        return null;
    }

    public ReplyInterface exceptionFilter(RequestInterface requestInterface, ProtocolException protocolException, FilterInterface[] filterInterfaceArray, int n) {
        return null;
    }

    static {
        Class<?> clazz = null;
        Attribute attribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.RequestedHeaderFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringArrayAttribute("header-names", null, 2);
        ATTR_HEADER_NAMES = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("send-header-list", Boolean.FALSE, 2);
        ATTR_SEND_HEADER_LIST = AttributeRegistry.registerAttribute(clazz, attribute);
    }
}

