/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.util.Properties;

public class Jdbc {
    public static final String MAX_CONNECTIONS_P = "org.w3c.tools.jdbc.maxconn";
    public static final int DEFAULT_MAX_CONN = 10;
    public static final String JDBC_DRIVER_P = "org.w3c.tools.jdbc.jdbcdriver";
    public static final String USER_P = "org.w3c.tools.jdbc.user";
    public static final String PASSWORD_P = "org.w3c.tools.jdbc.password";

    public static int getMaxConn(Properties properties) {
        return Jdbc.getInt(properties, MAX_CONNECTIONS_P, 10);
    }

    public static Properties setMaxConn(Properties properties, int n) {
        if (n < 1) {
            properties.put(MAX_CONNECTIONS_P, String.valueOf(10));
        } else {
            properties.put(MAX_CONNECTIONS_P, String.valueOf(n));
        }
        return properties;
    }

    public static String getDriver(Properties properties) {
        return (String)properties.get(JDBC_DRIVER_P);
    }

    public static Properties setDriver(Properties properties, String string) {
        if (string != null) {
            properties.put(JDBC_DRIVER_P, string);
        }
        return properties;
    }

    public static String getUser(Properties properties) {
        return (String)properties.get(USER_P);
    }

    public static Properties setUser(Properties properties, String string) {
        if (string != null) {
            properties.put(USER_P, string);
        }
        return properties;
    }

    public static String getPassword(Properties properties) {
        return (String)properties.get(PASSWORD_P);
    }

    public static Properties setPassword(Properties properties, String string) {
        if (string != null) {
            properties.put(PASSWORD_P, string);
        }
        return properties;
    }

    private static void setBoolean(Properties properties, String string, boolean bl) {
        properties.put(string, String.valueOf(bl));
    }

    private static boolean getBoolean(Properties properties, String string) {
        String string2 = (String)properties.get(string);
        if (string2 != null) {
            return string2.equalsIgnoreCase("true");
        }
        return false;
    }

    private static int getInt(Properties properties, String string, int n) {
        String string2 = (String)properties.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    private static void setInt(Properties properties, String string, int n) {
        String string2 = String.valueOf(n);
        properties.put(string, string2);
    }

    private static long getLong(Properties properties, String string, long l) {
        String string2 = (String)properties.get(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }
        return l;
    }

    private static void setLong(Properties properties, String string, long l) {
        String string2 = String.valueOf(l);
        properties.put(string, string2);
    }
}

