/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.sexpr;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.sexpr.Cons;
import org.w3c.tools.sexpr.DoubleFix;
import org.w3c.tools.sexpr.Readtable;
import org.w3c.tools.sexpr.SExpr;
import org.w3c.tools.sexpr.SExprParser;
import org.w3c.tools.sexpr.SExprParserException;
import org.w3c.tools.sexpr.SExprStream;
import org.w3c.tools.sexpr.SimpleReadtable;
import org.w3c.tools.sexpr.Symbol;

public class SimpleSExprStream
extends PushbackInputStream
implements SExprStream {
    private StringBuffer buffer = new StringBuffer();
    private Dictionary symbols = null;
    private boolean noSymbols = false;
    private Readtable readtable = null;
    private boolean listsAsVectors = false;

    public SimpleSExprStream(InputStream inputStream) {
        super(inputStream);
    }

    public Dictionary getSymbols() {
        if (!this.noSymbols && this.symbols == null) {
            this.symbols = new Hashtable();
        }
        return this.symbols;
    }

    public Dictionary setSymbols(Dictionary dictionary) {
        if (dictionary == null) {
            this.noSymbols = true;
        }
        this.symbols = dictionary;
        return this.symbols;
    }

    public Readtable getReadtable() {
        if (this.readtable == null) {
            this.readtable = new SimpleReadtable();
        }
        return this.readtable;
    }

    public Readtable setReadtable(Readtable readtable) {
        this.readtable = readtable;
        return this.readtable;
    }

    public boolean getListsAsVectors() {
        return this.listsAsVectors;
    }

    public boolean setListsAsVectors(boolean bl) {
        this.listsAsVectors = bl;
        return this.listsAsVectors;
    }

    public StringBuffer getScratchBuffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    public Object parse() throws SExprParserException, IOException {
        return this.parse(this.readSkipWhite(), this);
    }

    public Object parse(char c, SExprStream sExprStream) throws SExprParserException, IOException {
        SExprParser sExprParser = this.getReadtable().getParser(c);
        if (sExprParser != null) {
            return sExprParser.parse(c, this);
        }
        if (c == '(') {
            if (this.getListsAsVectors()) {
                return this.parseVector(new Vector(), ')');
            }
            return this.parseList();
        }
        if (c == '\"') {
            return this.parseString();
        }
        if (this.isAtomChar(c, true)) {
            return this.parseAtom(c);
        }
        throw new SExprParserException(c);
    }

    protected Cons parseList() throws SExprParserException, IOException {
        char c = this.readSkipWhite();
        if (c == ')') {
            return null;
        }
        this.unread(c);
        return new Cons(this.parse(), this.parseList());
    }

    protected Vector parseVector(Vector vector, char c) throws SExprParserException, IOException {
        char c2 = this.readSkipWhite();
        if (c2 == c) {
            return vector;
        }
        this.unread(c2);
        vector.addElement(this.parse());
        return this.parseVector(vector, c);
    }

    protected Object parseAtom(char c) throws SExprParserException, IOException {
        StringBuffer stringBuffer = this.getScratchBuffer();
        do {
            stringBuffer.append(c);
        } while (this.isAtomChar(c = (char)this.read(), false));
        this.unread(c);
        String string = stringBuffer.toString();
        try {
            return this.makeNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Symbol.makeSymbol(string, this.getSymbols());
        }
    }

    public String parseString() throws SExprParserException, IOException {
        StringBuffer stringBuffer = this.getScratchBuffer();
        while (true) {
            int n = this.read();
            switch (n) {
                case 34: {
                    return new String(stringBuffer);
                }
                case -1: {
                    throw new EOFException();
                }
            }
            stringBuffer.append((char)n);
        }
    }

    protected boolean isAtomChar(char c, boolean bl) {
        return !Character.isSpace(c) && c != '(' && c != ')' && c != '\"' && c != '}' && c != '{';
    }

    public char readSkipWhite() throws IOException {
        char c;
        do {
            if ((c = (char)this.read()) == ';') {
                while ((c = (char)this.read()) != '\n' && c != '\r') {
                }
            }
            if (c != '\uffffffff') continue;
            throw new EOFException();
        } while (Character.isSpace(c));
        return c;
    }

    protected Number makeNumber(String string) throws NumberFormatException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return DoubleFix.valueOf(string);
        }
    }

    public SExprParser addParser(char c, SExprParser sExprParser) {
        return this.getReadtable().addParser(c, sExprParser);
    }

    public static void printExpr(Object object, PrintStream printStream) {
        if (object == null) {
            printStream.print("nil");
        } else if (object instanceof Number) {
            printStream.print(object);
        } else if (object instanceof String) {
            printStream.print('\"');
            printStream.print(object);
            printStream.print('\"');
        } else if (object instanceof Vector) {
            printStream.print("(");
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                if (i != 0) {
                    printStream.print(" ");
                }
                SimpleSExprStream.printExpr(((Vector)object).elementAt(i), printStream);
            }
            printStream.print(")");
        } else if (object instanceof SExpr) {
            ((SExpr)object).printExpr(printStream);
        } else {
            printStream.print("#<unknown " + object + ">");
        }
    }

    public static void main(String[] stringArray) throws SExprParserException, IOException {
        SimpleSExprStream simpleSExprStream = new SimpleSExprStream(System.in);
        Object object = simpleSExprStream.parse();
        SimpleSExprStream.printExpr(object, System.out);
        System.out.println();
    }
}

