/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent;

import com.phloc.commons.lang.TimeValue;
import com.phloc.commons.state.ESuccess;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ThreadUtils {
    private ThreadUtils() {
    }

    @Nonnull
    public static ESuccess sleepMinutes(@Nonnegative long nMinutes) {
        if (nMinutes < 0L) {
            throw new IllegalArgumentException("Negative minutes: " + nMinutes);
        }
        return ThreadUtils.sleep(nMinutes * 60000L);
    }

    @Nonnull
    public static ESuccess sleepSeconds(@Nonnegative long nSeconds) {
        if (nSeconds < 0L) {
            throw new IllegalArgumentException("Negative seconds: " + nSeconds);
        }
        return ThreadUtils.sleep(nSeconds * 1000L);
    }

    @Nonnull
    public static ESuccess sleep(@Nonnull TimeValue aTimeValue) {
        if (aTimeValue == null) {
            throw new NullPointerException("timeValue");
        }
        return ThreadUtils.sleep(aTimeValue.getAsMillis());
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long nDuration, @Nonnull TimeUnit aTimeUnit) {
        if (nDuration < 0L) {
            throw new IllegalArgumentException("Negative duration: " + nDuration);
        }
        if (aTimeUnit == null) {
            throw new NullPointerException("timeUnit");
        }
        return ThreadUtils.sleep(aTimeUnit.toMillis(nDuration));
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long nMilliseconds) {
        if (nMilliseconds < 0L) {
            throw new IllegalArgumentException("Negative milliseconds: " + nMilliseconds);
        }
        try {
            Thread.sleep(nMilliseconds);
            return ESuccess.SUCCESS;
        }
        catch (InterruptedException ex) {
            return ESuccess.FAILURE;
        }
    }
}

