/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.graph.impl;

import com.phloc.commons.graph.IGraphNode;
import com.phloc.commons.graph.IGraphRelation;
import com.phloc.commons.graph.impl.AbstractGraphObject;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GraphRelation<VALUETYPE>
extends AbstractGraphObject
implements IGraphRelation<VALUETYPE> {
    private final IGraphNode<VALUETYPE> m_aFrom;
    private final IGraphNode<VALUETYPE> m_aTo;

    public GraphRelation(@Nonnull IGraphNode<VALUETYPE> aFrom, @Nonnull IGraphNode<VALUETYPE> aTo) {
        this(null, aFrom, aTo);
    }

    public GraphRelation(@Nullable String sID, @Nonnull IGraphNode<VALUETYPE> aFrom, @Nonnull IGraphNode<VALUETYPE> aTo) {
        super(sID);
        if (aFrom == null) {
            throw new NullPointerException("from");
        }
        if (aTo == null) {
            throw new NullPointerException("to");
        }
        this.m_aFrom = aFrom;
        this.m_aTo = aTo;
    }

    @Override
    @Nonnull
    public IGraphNode<VALUETYPE> getFrom() {
        return this.m_aFrom;
    }

    @Override
    @Nullable
    public VALUETYPE getFromValue() {
        return this.m_aFrom.getValue();
    }

    @Override
    @Nonnull
    public String getFromID() {
        return (String)this.m_aFrom.getID();
    }

    @Override
    @Nonnull
    public IGraphNode<VALUETYPE> getTo() {
        return this.m_aTo;
    }

    @Override
    @Nullable
    public VALUETYPE getToValue() {
        return this.m_aTo.getValue();
    }

    @Override
    @Nonnull
    public String getToID() {
        return (String)this.m_aTo.getID();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphRelation rhs = (GraphRelation)o;
        return this.m_aFrom.equals(rhs.m_aFrom) && this.m_aTo.equals(rhs.m_aTo);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFrom).append(this.m_aTo).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("from", this.m_aFrom).append("to", this.m_aTo).toString();
    }
}

