/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.CGlobal;
import com.phloc.commons.SystemProperties;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.io.file.FileOperations;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.misc.SizeHelper;
import com.phloc.commons.io.streams.CountingFileInputStream;
import com.phloc.commons.io.streams.CountingFileOutputStream;
import com.phloc.commons.state.EChange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileUtils.class);
    private static final FileUtils s_aInstance = new FileUtils();

    private FileUtils() {
    }

    public static boolean existsFile(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return aFile.isFile();
    }

    public static boolean existsDir(@Nonnull File aDir) {
        if (aDir == null) {
            throw new NullPointerException("directory");
        }
        return aDir.isDirectory();
    }

    public static boolean canRead(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return aFile.canRead();
    }

    public static boolean canWrite(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return aFile.canWrite();
    }

    public static boolean canExecute(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return aFile.canExecute();
    }

    public static boolean canReadAndWriteFile(@Nonnull File aFile) {
        File aParentFile;
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return !(FileUtils.existsFile(aFile) ? !FileUtils.canRead(aFile) || !FileUtils.canWrite(aFile) : (aParentFile = aFile.getParentFile()) != null && aParentFile.isDirectory() && (!FileUtils.canRead(aParentFile) || !FileUtils.canWrite(aParentFile)));
    }

    @Nonnull
    public static EChange ensureParentDirectoryIsPresent(@Nonnull File aFileObject) {
        if (aFileObject == null) {
            throw new NullPointerException("file");
        }
        File aParent = aFileObject.getParentFile();
        if (aParent == null || aParent.exists()) {
            if (aParent != null && !aParent.isDirectory()) {
                s_aLogger.warn("Parent object specified is not a directory: '" + aParent + "'");
            }
            return EChange.UNCHANGED;
        }
        FileIOError aError = FileOperations.createDirRecursive(aParent);
        if (aError.isFailure()) {
            throw new IllegalStateException("Failed to create parent of " + aFileObject.getAbsolutePath() + ": " + aError);
        }
        if (!aParent.exists()) {
            throw new IllegalStateException("Parent of " + aFileObject.getAbsolutePath() + " is still not existing!");
        }
        return EChange.CHANGED;
    }

    @Nullable
    public static File getCanonicalFile(@Nullable File aFile) throws IOException {
        return aFile == null ? null : aFile.getCanonicalFile();
    }

    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static boolean isParentDirectory(@Nonnull File aSearchDirectory, @Nonnull File aStartDirectory) {
        if (aSearchDirectory == null) {
            throw new NullPointerException("search directory");
        }
        if (aStartDirectory == null) {
            throw new NullPointerException("start directory");
        }
        File aRealSearchDirectory = aSearchDirectory.getAbsoluteFile();
        File aRealStartDirectory = aStartDirectory.getAbsoluteFile();
        try {
            aRealSearchDirectory = FileUtils.getCanonicalFile(aRealSearchDirectory);
            aRealStartDirectory = FileUtils.getCanonicalFile(aRealStartDirectory);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!aRealSearchDirectory.isDirectory()) {
            return false;
        }
        for (File aParent = aRealStartDirectory; aParent != null; aParent = aParent.getParentFile()) {
            if (!aParent.equals(aRealSearchDirectory)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FileInputStream getInputStream(@Nonnull String sFilename) {
        return FileUtils.getInputStream(new File(sFilename));
    }

    @Nullable
    public static FileInputStream getInputStream(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        try {
            return new CountingFileInputStream(aFile);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull String sFilename) {
        return FileUtils.getOutputStream(sFilename, EAppend.DEFAULT);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull String sFilename, @Nonnull EAppend eAppend) {
        return FileUtils.getOutputStream(new File(sFilename), eAppend);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull File aFile) {
        return FileUtils.getOutputStream(aFile, EAppend.DEFAULT);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull File aFile, @Nonnull EAppend eAppend) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (eAppend == null) {
            throw new NullPointerException("append");
        }
        try {
            FileUtils.ensureParentDirectoryIsPresent(aFile);
        }
        catch (IllegalStateException ex) {
            s_aLogger.warn("Failed to create parent directory of '" + aFile + "'", (Throwable)ex);
            return null;
        }
        File aParentDir = aFile.getParentFile();
        if (aParentDir != null && !FileUtils.canWrite(aParentDir)) {
            s_aLogger.warn("Parent directory '" + aParentDir + "' of '" + aFile + "' is not writable for current user '" + SystemProperties.getUserName() + "'");
            return null;
        }
        try {
            return new CountingFileOutputStream(aFile, eAppend);
        }
        catch (FileNotFoundException ex) {
            s_aLogger.warn("Failed to create output stream for '" + aFile + "'; append: " + eAppend + ": " + ex.getClass().getName() + " - " + ex.getMessage());
            return null;
        }
    }

    public static boolean isFileNewer(@Nonnull File aFile1, @Nonnull File aFile2) {
        if (aFile1 == null) {
            throw new NullPointerException("firstFile");
        }
        if (aFile2 == null) {
            throw new NullPointerException("secondFile");
        }
        if (aFile1.equals(aFile2)) {
            return false;
        }
        if (!aFile1.exists()) {
            return false;
        }
        if (!aFile2.exists()) {
            return true;
        }
        return aFile1.lastModified() > aFile2.lastModified();
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nullable File aFile) {
        return FileUtils.getFileSizeDisplay(aFile, 0);
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nullable File aFile, @Nonnegative int nDecimals) {
        if (aFile != null && aFile.exists()) {
            return FileUtils.getFileSizeDisplay(aFile.length(), nDecimals);
        }
        return "";
    }

    @Nonnull
    public static String getFileSizeDisplay(long nFileSize) {
        return FileUtils.getFileSizeDisplay(nFileSize, 0);
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nonnegative long nFileSize, @Nonnegative int nDecimals) {
        if (nFileSize < 0L) {
            throw new IllegalArgumentException("File size may not be negative!");
        }
        if (nDecimals < 0) {
            throw new IllegalArgumentException("Decimals may not be negative!");
        }
        return SizeHelper.getSizeHelperOfLocale(CGlobal.LOCALE_FIXED_NUMBER_FORMAT).getAsMatching(nFileSize, nDecimals);
    }

    @Nullable
    public static File getSecureFile(@Nullable File aFile) {
        if (aFile == null) {
            return null;
        }
        String sRet = null;
        for (File aWork = new File(FilenameHelper.getCleanPath(aFile)); aWork != null; aWork = aWork.getParentFile()) {
            String sSecuredName = aWork.getParent() == null ? aWork.getPath() : FilenameHelper.getAsSecureValidFilename(aWork.getName());
            sRet = sRet == null ? sSecuredName : sSecuredName + "/" + sRet;
        }
        return new File(sRet);
    }

    @Nonnegative
    public static int getDirectoryObjectCount(@Nonnull File aDirectory) {
        if (aDirectory == null) {
            throw new NullPointerException("directory");
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Passed object is not a directory: " + aDirectory);
        }
        int ret = 0;
        for (File aChild : FileUtils.getDirectoryContent(aDirectory)) {
            if (FilenameHelper.isSystemInternalDirectory(aChild.getName())) continue;
            ++ret;
        }
        return ret;
    }

    public static boolean safeEquals(@Nullable File f1, @Nullable File f2) {
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        return FilenameHelper.getCleanPath(f1.getAbsoluteFile()).equals(FilenameHelper.getCleanPath(f2.getAbsoluteFile()));
    }

    @Nonnull
    @ReturnsMutableCopy
    private static List<File> _getDirectoryContent(@Nonnull File aDirectory, @Nullable File[] aSelectedContent) {
        if (aSelectedContent == null) {
            if (!aDirectory.isDirectory()) {
                s_aLogger.warn("Cannot list non-directory: " + aDirectory.getAbsolutePath());
            } else if (!FileUtils.canExecute(aDirectory)) {
                s_aLogger.warn("Existing directory is missing the listing permission: " + aDirectory.getAbsolutePath());
            } else if (!FileUtils.canRead(aDirectory)) {
                s_aLogger.warn("Cannot list directory because of no read-rights: " + aDirectory.getAbsolutePath());
            } else {
                s_aLogger.warn("Directory listing failed because of IO error: " + aDirectory.getAbsolutePath());
            }
        } else if (!FileUtils.canExecute(aDirectory)) {
            s_aLogger.warn("Directory is missing the listing permission: " + aDirectory.getAbsolutePath());
        }
        return ContainerHelper.newList(aSelectedContent);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<File> getDirectoryContent(@Nonnull File aDirectory) {
        if (aDirectory == null) {
            throw new NullPointerException("directory");
        }
        return FileUtils._getDirectoryContent(aDirectory, aDirectory.listFiles());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<File> getDirectoryContent(@Nonnull File aDirectory, @Nonnull FilenameFilter aFilenameFilter) {
        if (aDirectory == null) {
            throw new NullPointerException("directory");
        }
        if (aFilenameFilter == null) {
            throw new NullPointerException("filenameFilter");
        }
        return FileUtils._getDirectoryContent(aDirectory, aDirectory.listFiles(aFilenameFilter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<File> getDirectoryContent(@Nonnull File aDirectory, @Nonnull FileFilter aFileFilter) {
        if (aDirectory == null) {
            throw new NullPointerException("directory");
        }
        if (aFileFilter == null) {
            throw new NullPointerException("fileFilter");
        }
        return FileUtils._getDirectoryContent(aDirectory, aDirectory.listFiles(aFileFilter));
    }
}

