/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import java.math.BigInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FactorialHelper {
    private static final long[] PREDEFINED_FACTORIALS_LONG = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    public static final int PREDEFINED_MIN_INDEX = 0;
    public static final int PREDEFINED_MAX_INDEX = PREDEFINED_FACTORIALS_LONG.length - 1;
    private static final FactorialHelper s_aInstance = new FactorialHelper();

    private FactorialHelper() {
    }

    @Nonnegative
    public static long getSmallFactorial(@Nonnegative int n) {
        if (n < 0 || n > PREDEFINED_MAX_INDEX) {
            throw new IllegalArgumentException("Passed index " + n + " is out of bounds");
        }
        return PREDEFINED_FACTORIALS_LONG[n];
    }

    @Nonnull
    public static BigInteger getAnyFactorialLinear(@Nonnegative int n) {
        return new FactorialSplit().getFactorial(n);
    }

    private static final class FactorialSplit {
        private long m_nCurrentN;

        private FactorialSplit() {
        }

        @Nonnull
        private BigInteger _getProduct(int n) {
            int m = n / 2;
            if (m == 0) {
                this.m_nCurrentN += 2L;
                return BigInteger.valueOf(this.m_nCurrentN);
            }
            if (n == 2) {
                this.m_nCurrentN += 2L;
                long n1 = this.m_nCurrentN;
                this.m_nCurrentN += 2L;
                long n2 = this.m_nCurrentN;
                return BigInteger.valueOf(n1 * n2);
            }
            return this._getProduct(n - m).multiply(this._getProduct(m));
        }

        @Nonnull
        public BigInteger getFactorial(@Nonnegative int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n >= 0 required, but was " + n);
            }
            if (n < 2) {
                return BigInteger.ONE;
            }
            BigInteger aP = BigInteger.ONE;
            BigInteger aR = BigInteger.ONE;
            this.m_nCurrentN = 1L;
            int nH = 0;
            int nShift = 0;
            int nHigh = 1;
            int nLog2n = 31 - Integer.numberOfLeadingZeros(n);
            while (nH != n) {
                nShift += nH;
                nH = n >> nLog2n--;
                int nLen = nHigh;
                nHigh = nH - 1 | 1;
                if ((nLen = (nHigh - nLen) / 2) <= 0) continue;
                aP = aP.multiply(this._getProduct(nLen));
                aR = aR.multiply(aP);
            }
            return aR.shiftLeft(nShift);
        }
    }
}

