/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.format.impl;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.format.IFormatter;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.TypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractStringFormatter
implements IFormatter {
    private final IFormatter m_aPrevFormatter;

    public AbstractStringFormatter(@Nullable IFormatter aPrevFormatter) {
        this.m_aPrevFormatter = aPrevFormatter;
    }

    @Nonnull
    @OverrideOnDemand
    protected String getValueAsString(@Nullable Object aValue) {
        String sValue = TypeConverter.convertIfNecessary(aValue, String.class);
        return sValue != null ? sValue : StringHelper.getToString(aValue);
    }

    protected abstract String getFormattedValueAsString(@Nullable Object var1);

    @Override
    @Nullable
    public final String getFormattedValue(@Nullable Object aValue) {
        Object aBase = this.m_aPrevFormatter == null ? aValue : this.m_aPrevFormatter.getFormattedValue(aValue);
        return this.getFormattedValueAsString(aBase);
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("prevFormatter", this.m_aPrevFormatter).toString();
    }
}

