/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WrappedWriter
extends Writer {
    private final Writer m_aWrappedWriter;

    public WrappedWriter(@Nonnull Writer aWrappedWriter) {
        if (aWrappedWriter == null) {
            throw new NullPointerException("wrappedWriter");
        }
        this.m_aWrappedWriter = aWrappedWriter;
    }

    @Override
    public void write(int c) throws IOException {
        this.m_aWrappedWriter.write(c);
    }

    @Override
    public void write(@Nonnull char[] aBuf) throws IOException {
        this.write(aBuf, 0, aBuf.length);
    }

    @Override
    public void write(@Nonnull char[] aBuf, @Nonnegative int nOfs, @Nonnegative int nLen) throws IOException {
        this.m_aWrappedWriter.write(aBuf, nOfs, nLen);
    }

    @Override
    public void write(@Nonnull String sStr) throws IOException {
        this.m_aWrappedWriter.write(sStr);
    }

    @Override
    public void write(@Nonnull String sStr, @Nonnegative int nOfs, @Nonnegative int nLen) throws IOException {
        this.m_aWrappedWriter.write(sStr, nOfs, nLen);
    }

    @Override
    public WrappedWriter append(@Nullable CharSequence csq) throws IOException {
        this.m_aWrappedWriter.append(csq);
        return this;
    }

    @Override
    public WrappedWriter append(@Nullable CharSequence csq, @Nonnegative int nStart, @Nonnegative int nEnd) throws IOException {
        this.m_aWrappedWriter.append(csq, nStart, nEnd);
        return this;
    }

    @Override
    public WrappedWriter append(char c) throws IOException {
        this.m_aWrappedWriter.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.m_aWrappedWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_aWrappedWriter.close();
    }

    public String toString() {
        return new ToStringGenerator(this).append("wrappedWriter", this.m_aWrappedWriter).toString();
    }
}

