/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.frames.MimeTypeAttribute;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.resources.ImageFileResource;
import org.w3c.tools.jpeg.JpegHeaders;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.event.AttributeChangedEvent;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class JpegComFrame
extends HTTPFrame {
    public static final boolean debug = false;
    protected static int ATTR_COM_TYPE = -1;
    protected static String[] vary;
    protected HttpEntityTag cometag = null;
    protected String comment = null;

    public MimeType getCommentType() {
        return (MimeType)this.getValue(ATTR_COM_TYPE, null);
    }

    protected String getMetadata() {
        if (this.fresource == null) {
            return null;
        }
        File file = this.fresource.getFile();
        if (file.exists()) {
            String[] stringArray = null;
            try {
                JpegHeaders jpegHeaders = new JpegHeaders(file);
                stringArray = jpegHeaders.getComments();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "unable to get comment: " + exception.getMessage();
            }
            this.comment = "";
            for (int i = 0; i < stringArray.length; ++i) {
                this.comment = this.comment + stringArray[i];
            }
            if (this.comment.equals("")) {
                this.comment = "no comment";
            }
        }
        return this.comment;
    }

    public HttpEntityTag getComETag() {
        if (this.cometag == null) {
            long l;
            String string = null;
            if (this.fresource != null && (l = this.fresource.getFileStamp() + 1L) >= 0L) {
                String string2 = Integer.toString(this.getOid(), 32);
                String string3 = Long.toString(l, 32);
                string = Integer.toString(this.getOid(), 32) + ":" + Long.toString(l, 32);
            }
            this.cometag = HttpFactory.makeETag(false, string);
        }
        return this.cometag;
    }

    protected void updateCachedHeaders() {
        super.updateCachedHeaders();
        if (this.comment == null) {
            this.comment = this.getMetadata();
        }
    }

    public void attributeChanged(AttributeChangedEvent attributeChangedEvent) {
        super.attributeChanged(attributeChangedEvent);
        String string = attributeChangedEvent.getAttribute().getName();
        if (string.equals("file-stamp") || string.equals("file-stamp")) {
            this.comment = null;
        }
    }

    public Reply createCommentReply(Request request, int n) {
        long l;
        Reply reply = request.makeReply(n);
        this.updateCachedHeaders();
        reply.setContent(this.comment);
        reply.setContentType(this.getCommentType());
        reply.setVary(vary);
        if (this.lastmodified != null) {
            reply.setHeaderValue(Reply.H_LAST_MODIFIED, (HeaderValue)this.lastmodified);
        }
        if (this.contentencoding != null) {
            reply.setHeaderValue(Reply.H_CONTENT_ENCODING, (HeaderValue)this.contentencoding);
        }
        if (this.contentlanguage != null) {
            reply.setHeaderValue(Reply.H_CONTENT_LANGUAGE, (HeaderValue)this.contentlanguage);
        }
        if ((l = this.getMaxAge()) >= 0L && reply.getMajorVersion() >= 1) {
            if (reply.getMinorVersion() >= 1) {
                reply.setMaxAge((int)(l / 1000L));
            }
            long l2 = System.currentTimeMillis() + (l == 0L ? -1000L : l);
            reply.setExpires(l2);
        }
        reply.setDate(System.currentTimeMillis() / 1000L * 1000L);
        reply.setETag(this.getComETag());
        String string = this.getCommentType().toString();
        reply.setContentLocation(this.getURL(request).toExternalForm() + ";" + URLEncoder.encode(string));
        return reply;
    }

    public Reply createCommentReply(Request request) {
        return this.createCommentReply(request, 200);
    }

    public int checkIfMatch(Request request, HttpEntityTag httpEntityTag) {
        HttpEntityTag[] httpEntityTagArray;
        if (this.fresource != null && (httpEntityTagArray = request.getIfMatch()) != null) {
            if (httpEntityTag != null) {
                for (int i = 0; i < httpEntityTagArray.length; ++i) {
                    HttpEntityTag httpEntityTag2 = httpEntityTagArray[i];
                    if (!httpEntityTag2.getTag().equals(httpEntityTag.getTag())) continue;
                    if (httpEntityTag2.isWeak() || httpEntityTag.isWeak()) {
                        return 3;
                    }
                    return 2;
                }
            }
            return 1;
        }
        return 0;
    }

    public int checkIfNoneMatch(Request request, HttpEntityTag httpEntityTag) {
        HttpEntityTag[] httpEntityTagArray;
        if (this.fresource != null && (httpEntityTagArray = request.getIfNoneMatch()) != null) {
            if (httpEntityTag == null) {
                return 2;
            }
            int n = 2;
            for (int i = 0; i < httpEntityTagArray.length; ++i) {
                HttpEntityTag httpEntityTag2 = httpEntityTagArray[i];
                if (httpEntityTag2.getTag().equals(httpEntityTag.getTag())) {
                    if (httpEntityTag2.isWeak() || httpEntityTag.isWeak()) {
                        n = 3;
                    } else {
                        return 1;
                    }
                }
                if (!httpEntityTag2.getTag().equals("*")) continue;
                if (this.fresource != null) {
                    File file = this.fresource.getFile();
                    if (!file.exists()) continue;
                    return 1;
                }
                return 1;
            }
            return n;
        }
        return 0;
    }

    public int checkValidators(Request request, HttpEntityTag httpEntityTag) {
        int n = this.checkIfNoneMatch(request, httpEntityTag);
        int n2 = this.checkIfModifiedSince(request);
        if (n == 2 || n2 == 2) {
            return 2;
        }
        if (n == 1 || n2 == 1) {
            return 1;
        }
        if (n == 3 || n2 == 3) {
            return 2;
        }
        return 0;
    }

    protected boolean negotiate(Request request) throws ProtocolException {
        if (!request.hasAccept()) {
            return false;
        }
        HttpAccept[] httpAcceptArray = request.getAccept();
        HttpAccept httpAccept = this.getMatchingAccept(httpAcceptArray, this.getContentType());
        HttpAccept httpAccept2 = this.getMatchingAccept(httpAcceptArray, this.getCommentType());
        if (httpAccept != null && httpAccept2 != null) {
            int n;
            int n2 = this.getContentType().match(httpAccept.getMimeType());
            if (n2 == (n = this.getCommentType().match(httpAccept2.getMimeType()))) {
                return httpAccept.getQuality() < httpAccept2.getQuality();
            }
            return n2 < n;
        }
        return httpAccept2 != null;
    }

    protected HttpAccept getMatchingAccept(HttpAccept[] httpAcceptArray, MimeType mimeType) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < httpAcceptArray.length; ++i) {
            try {
                int n3 = mimeType.match(httpAcceptArray[i].getMimeType());
                if (n3 <= n) continue;
                n = n3;
                n2 = i;
                continue;
            }
            catch (HttpInvalidValueException httpInvalidValueException) {
                // empty catch block
            }
        }
        if (n2 < 0) {
            return null;
        }
        return httpAcceptArray[n2];
    }

    protected Reply headFileResource(Request request) throws ProtocolException, ResourceException {
        Object object;
        if (this.fresource == null) {
            throw new ResourceException("this frame is not attached to a FileResource. (" + this.resource.getIdentifier() + ")");
        }
        Reply reply = null;
        this.fresource.checkContent();
        this.updateCachedHeaders();
        String string = null;
        String string2 = request.getURL().getFile();
        int n = string2.indexOf(59);
        if (n != -1) {
            string = (String)request.getState("type");
        }
        if (string != null) {
            HttpAccept[] httpAcceptArray = request.getAccept();
            object = null;
            if (httpAcceptArray != null) {
                object = new HttpAccept[httpAcceptArray.length + 1];
                System.arraycopy(httpAcceptArray, 0, object, 1, httpAcceptArray.length);
            } else {
                object = new HttpAccept[1];
            }
            try {
                object[0] = HttpFactory.makeAccept(new MimeType(string), 1.1);
                request.setAccept((HttpAccept[])object);
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {
                // empty catch block
            }
        }
        boolean bl = this.negotiate(request);
        object = null;
        object = bl ? this.getComETag() : this.getETag();
        int n2 = this.checkIfMatch(request, (HttpEntityTag)object);
        if (n2 == 1 || n2 == 3) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkIfUnmodifiedSince(request) == 1) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkValidators(request, (HttpEntityTag)object) == 1) {
            reply = this.createDefaultReply(request, 304);
            reply.setETag((HttpEntityTag)object);
            reply.setContentMD5(null);
            return reply;
        }
        if (!this.fresource.getFile().exists()) {
            return this.deleteMe(request);
        }
        if (bl) {
            reply = this.createCommentReply(request);
            reply.setStream((InputStream)null);
        } else {
            reply = this.createDefaultReply(request, 200);
            reply.setVary(vary);
        }
        if (request.hasState("org.w3c.jigsaw.frames.HTTPFrame.cl")) {
            reply.setContentLocation(this.getURL(request).toExternalForm());
        }
        return reply;
    }

    protected Reply getFileResource(Request request) throws ProtocolException, ResourceException {
        Object object;
        if (this.fresource == null) {
            throw new ResourceException("this frame is not attached to a FileResource. (" + this.resource.getIdentifier() + ")");
        }
        Reply reply = null;
        File file = this.fresource.getFile();
        this.fresource.checkContent();
        this.updateCachedHeaders();
        String string = null;
        String string2 = request.getURL().getFile();
        int n = string2.indexOf(59);
        if (n != -1) {
            string = (String)request.getState("type");
        }
        if (string != null) {
            HttpAccept[] httpAcceptArray = request.getAccept();
            object = null;
            if (httpAcceptArray != null) {
                object = new HttpAccept[httpAcceptArray.length + 1];
                System.arraycopy(httpAcceptArray, 0, object, 1, httpAcceptArray.length);
            } else {
                object = new HttpAccept[1];
            }
            try {
                object[0] = HttpFactory.makeAccept(new MimeType(string), 1.1);
                request.setAccept((HttpAccept[])object);
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {
                // empty catch block
            }
        }
        boolean bl = this.negotiate(request);
        object = null;
        object = bl ? this.getComETag() : this.getETag();
        int n2 = this.checkIfMatch(request, (HttpEntityTag)object);
        if (n2 == 1 || n2 == 3) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkIfUnmodifiedSince(request) == 1) {
            reply = request.makeReply(412);
            reply.setContent("Pre-conditions failed.");
            reply.setContentMD5(null);
            return reply;
        }
        if (this.checkValidators(request, (HttpEntityTag)object) == 1) {
            reply = this.createDefaultReply(request, 304);
            reply.setETag((HttpEntityTag)object);
            reply.setContentMD5(null);
            return reply;
        }
        if (file.exists()) {
            reply = bl ? this.createCommentReply(request) : this.createFileReply(request);
            if (request.hasState("org.w3c.jigsaw.frames.HTTPFrame.cl")) {
                reply.setContentLocation(this.getURL(request).toExternalForm());
            }
            return reply;
        }
        return this.deleteMe(request);
    }

    protected Reply putFileResource(Request request) throws ProtocolException, ResourceException {
        Object object;
        Cloneable cloneable;
        if (!(this.fresource instanceof ImageFileResource)) {
            return super.putFileResource(request);
        }
        Reply reply = null;
        int n = 200;
        this.fresource.checkContent();
        this.updateCachedHeaders();
        if (!this.getPutableFlag()) {
            Reply reply2 = request.makeReply(405);
            reply2.setContent("Method PUT not allowed.");
            throw new HTTPException(reply2);
        }
        HttpEntityTag httpEntityTag = this.getComETag();
        int n2 = this.checkIfMatch(request, httpEntityTag);
        if (request.getIfMatch() == null || n2 == 1 || n2 == 3) {
            return super.putFileResource(request);
        }
        if (this.checkIfNoneMatch(request, httpEntityTag) == 1 || this.checkIfModifiedSince(request) == 1 || this.checkIfUnmodifiedSince(request) == 1) {
            Reply reply3 = request.makeReply(412);
            reply3.setContent("Pre-condition failed.");
            return reply3;
        }
        InputStream inputStream = null;
        try {
            inputStream = request.getInputStream();
            if (inputStream == null) {
                Reply reply4 = request.makeReply(400);
                reply4.setContent("<p>Request doesn't have a valid content.");
                throw new HTTPException(reply4);
            }
        }
        catch (IOException iOException) {
            throw new ClientException(request.getClient(), iOException);
        }
        if (request.hasContentRange()) {
            Reply reply5 = request.makeReply(400);
            reply5.setContent("partial PUT not supported.");
            throw new HTTPException(reply5);
        }
        if (request.hasContentType()) {
            cloneable = request.getContentType();
            object = this.getCommentType();
            if (object == null) {
                this.setValue(ATTR_CONTENT_TYPE, (Object)cloneable);
            } else if (((MimeType)cloneable).match((MimeType)object) < 0) {
                Reply reply6 = request.makeReply(415);
                reply6.setContent("<p>Invalid content type: " + ((MimeType)object).toString());
                throw new HTTPException(reply6);
            }
        }
        cloneable = (ImageFileResource)this.fresource;
        try {
            object = request.getClient();
            if (object != null && request.getExpect() != null) {
                ((Client)object).sendContinue();
            }
            n = ((ImageFileResource)cloneable).newMetadataContent(request.getInputStream()) ? 201 : 204;
        }
        catch (IOException iOException) {
            throw new ClientException(request.getClient(), iOException);
        }
        if (n == 201) {
            reply = this.createCommentReply(request, n);
            reply.setContent("<P>Resource succesfully created");
            if (request.hasState("org.w3c.jigsaw.frames.HTTPFrame.cl")) {
                reply.setContentLocation(this.getURL(request).toExternalForm());
            }
            if (this.fresource != null && httpEntityTag == null) {
                reply.setETag(this.getComETag());
            }
            reply.setLocation(this.getURL(request));
            reply.setContent("<p>Entity body saved succesfully !");
        } else {
            reply = this.createCommentReply(request, n);
        }
        return reply;
    }

    static {
        MimeTypeAttribute mimeTypeAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.frames.JpegComFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        mimeTypeAttribute = new MimeTypeAttribute("comment-type", null, 2);
        ATTR_COM_TYPE = AttributeRegistry.registerAttribute(clazz, mimeTypeAttribute);
        vary = new String[]{"Accept"};
    }
}

