/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.AbstractCSSProperty;
import com.phloc.css.property.ECSSProperty;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyEnum
extends AbstractCSSProperty {
    protected final Set<String> m_aEnumValues;

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, String ... aEnumValues) {
        super(eProp);
        this.m_aEnumValues = new HashSet<String>(aEnumValues.length);
        for (String sPotentialValue : aEnumValues) {
            if (StringHelper.hasNoText((CharSequence)sPotentialValue)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(sPotentialValue);
        }
        if (this.m_aEnumValues.isEmpty()) {
            throw new IllegalArgumentException("At least one enumeration value needs to be passed!");
        }
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp);
        this.m_aEnumValues = new HashSet<String>();
        for (String sPotentialValue : aEnumValues) {
            if (StringHelper.hasNoText((CharSequence)sPotentialValue)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(sPotentialValue);
        }
        if (this.m_aEnumValues.isEmpty()) {
            throw new IllegalArgumentException("At least one enumeration value needs to be passed!");
        }
    }

    private CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nonnull @Nonempty Set<String> aEnumValues) {
        super(eProp);
        this.m_aEnumValues = new HashSet<String>(aEnumValues);
    }

    @Override
    public boolean isValidValue(@Nullable String sValue) {
        return this.m_aEnumValues.contains(sValue);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnum(eProp, this.m_aEnumValues);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("enumValues", this.m_aEnumValues).toString();
    }
}

