/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;
import org.w3c.util.LookupTable;
import org.w3c.www.protocol.http.cache.CacheGeneration;
import org.w3c.www.protocol.http.cache.CacheSerializer;
import org.w3c.www.protocol.http.cache.CacheStore;
import org.w3c.www.protocol.http.cache.CachedResource;

public class SimpleCacheSerializer
extends CacheSerializer {
    protected XMLSerializer serializer = new XMLSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGeneration(CacheGeneration cacheGeneration, Writer writer) throws IOException {
        CacheGeneration cacheGeneration2 = cacheGeneration;
        synchronized (cacheGeneration2) {
            this._writeGeneration(cacheGeneration, writer);
        }
    }

    private void _writeGeneration(CacheGeneration cacheGeneration, Writer writer) throws IOException {
        Enumeration enumeration = cacheGeneration.getCachedResources();
        Vector vector = new Vector(10);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new CachedResource[vector.size()];
        vector.copyInto(objectArray);
        try {
            this.serializer.writeResources((AttributeHolder[])objectArray, writer);
        }
        catch (SerializationException serializationException) {
            String string = "XML Serialization, write failed : " + serializationException.getMessage();
            throw new IOException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGenerationList(CacheStore cacheStore) throws IOException {
        CacheStore cacheStore2 = cacheStore;
        synchronized (cacheStore2) {
            CacheGeneration cacheGeneration = cacheStore.getMRUGeneration();
            while (cacheGeneration != null && !cacheGeneration.isSaved()) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(cacheGeneration.getGenerationFile()));
                this._writeGeneration(cacheGeneration, bufferedWriter);
                cacheGeneration = cacheStore.getNextGeneration(cacheGeneration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheGeneration readGeneration(CacheGeneration cacheGeneration, Reader reader) throws IOException {
        CacheGeneration cacheGeneration2 = cacheGeneration;
        synchronized (cacheGeneration2) {
            cacheGeneration.clean();
            AttributeHolder[] attributeHolderArray = null;
            try {
                attributeHolderArray = this.serializer.readAttributeHolders(reader);
            }
            catch (SerializationException serializationException) {
                String string = "XML Serialization, load failed : " + serializationException.getMessage();
                throw new IOException(string);
            }
            for (int i = 0; i < attributeHolderArray.length; ++i) {
                cacheGeneration.loadCachedResource((CachedResource)attributeHolderArray[i]);
            }
            cacheGeneration.setLoaded(true);
            cacheGeneration.setSaved(true);
            return cacheGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheGeneration readDescription(CacheGeneration cacheGeneration, Reader reader) throws IOException {
        LookupTable[] lookupTableArray = null;
        try {
            lookupTableArray = this.serializer.readAttributes(reader, CachedResource.ATTR_DESCR);
        }
        catch (SerializationException serializationException) {
            String string = "XML Serialization, load failed : " + serializationException.getMessage();
            throw new IOException(string);
        }
        CacheGeneration cacheGeneration2 = cacheGeneration;
        synchronized (cacheGeneration2) {
            cacheGeneration.setDescription(lookupTableArray);
        }
        return cacheGeneration;
    }

    public void write(AttributeHolder attributeHolder, Writer writer) throws IOException {
        AttributeHolder[] attributeHolderArray = new AttributeHolder[]{attributeHolder};
        try {
            this.serializer.writeResources(attributeHolderArray, writer);
        }
        catch (SerializationException serializationException) {
            String string = "XML Serialization, save failed : " + serializationException.getMessage();
            throw new IOException(string);
        }
    }

    public AttributeHolder read(Reader reader) throws IOException {
        try {
            AttributeHolder[] attributeHolderArray = this.serializer.readAttributeHolders(reader);
            if (attributeHolderArray != null && attributeHolderArray.length > 0) {
                return attributeHolderArray[0];
            }
            throw new IOException("empty!");
        }
        catch (SerializationException serializationException) {
            String string = "XML Serialization, load failed : " + serializationException.getMessage();
            throw new IOException(string);
        }
    }
}

