/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.io.file.EFileIOErrorCode;
import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.io.file.IFileOperationCallback;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingFileOperationCallback
implements IFileOperationCallback {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingFileOperationCallback.class);

    @Override
    public void onSuccess(@Nonnull EFileIOOperation eOperation, @Nonnull File aFile1, @Nullable File aFile2) {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("File operation " + eOperation.name() + " succeeded on '" + aFile1 + "'" + (aFile2 == null ? "" : " and '" + aFile2 + "'"));
        }
    }

    @Override
    public void onError(@Nonnull EFileIOOperation eOperation, @Nonnull EFileIOErrorCode eErrorCode, @Nonnull File aFile1, @Nullable File aFile2, @Nullable Exception aException) {
        s_aLogger.warn("File operation " + eOperation.name() + " failed with error code " + eErrorCode.name() + " on '" + aFile1 + "'" + (aFile2 == null ? "" : " and '" + aFile2 + "'"), (Throwable)aException);
    }
}

