/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.io.IInputStreamAndReaderProvider;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ByteArrayInputStreamProvider
implements IInputStreamAndReaderProvider {
    private final byte[] m_aData;
    private final int m_nOfs;
    private final int m_nLen;

    public ByteArrayInputStreamProvider(@Nonnull byte[] aData) {
        this(aData, 0, aData.length);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ByteArrayInputStreamProvider(@Nonnull byte[] aInput, @Nonnegative int nOfs, @Nonnegative int nLen) {
        if (aInput == null) {
            throw new NullPointerException("input");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aInput.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aInput.length);
        }
        this.m_aData = aInput;
        this.m_nOfs = nOfs;
        this.m_nLen = nLen;
    }

    @Override
    @Nonnull
    public final InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aData);
    }

    @Override
    @Nonnull
    public final Reader getReader(@Nonnull String sCharset) {
        return StreamUtils.createReader(this.getInputStream(), sCharset);
    }

    @Override
    @Nonnull
    public final Reader getReader(@Nonnull Charset aCharset) {
        return StreamUtils.createReader(this.getInputStream(), aCharset);
    }

    public String toString() {
        return new ToStringGenerator(null).append("byteArray[]", this.m_aData.length + " bytes").append("ofs", this.m_nOfs).append("len", this.m_nLen).toString();
    }
}

