/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LocaleCache {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, Locale> s_aLocales = new HashMap<String, Locale>();
    private static final LocaleCache s_aInstance;

    private LocaleCache() {
    }

    private static void _initialAdd(@Nonnull Locale aLocale) {
        s_aLocales.put(aLocale.toString(), aLocale);
    }

    @Nullable
    public static Locale getLocale(@Nullable String sLanguage) {
        if (sLanguage != null && sLanguage.length() > 2) {
            String[] aParts = StringHelper.getExplodedArray('_', sLanguage, 3);
            if (aParts.length == 3) {
                return LocaleCache.getLocale(aParts[0], aParts[1], aParts[2]);
            }
            if (aParts.length == 2) {
                return LocaleCache.getLocale(aParts[0], aParts[1], "");
            }
        }
        return LocaleCache.getLocale(sLanguage, "", "");
    }

    @Nullable
    public static Locale getLocale(@Nullable String sLanguage, @Nullable String sCountry) {
        return LocaleCache.getLocale(sLanguage, sCountry, "");
    }

    @Nonnull
    private static String _buildLocaleString(@Nonnull String sLanguage, @Nonnull String sCountry, @Nonnull String sVariant) {
        StringBuilder aLocaleSB = new StringBuilder();
        if (sLanguage.length() > 0) {
            aLocaleSB.append(sLanguage);
        }
        if (sCountry.length() > 0) {
            aLocaleSB.append('_').append(sCountry);
        }
        if (sVariant.length() > 0) {
            aLocaleSB.append('_').append(sVariant);
        }
        return aLocaleSB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Locale getLocale(@Nullable String sLanguage, @Nullable String sCountry, @Nullable String sVariant) {
        Locale aLocale;
        String sRealVariant;
        String sRealCountry;
        String sRealLanguage = sLanguage == null ? "" : sLanguage.toLowerCase();
        String sLocaleKey = LocaleCache._buildLocaleString(sRealLanguage, sRealCountry = sCountry == null ? "" : sCountry.toUpperCase(), sRealVariant = sVariant == null ? "" : sVariant);
        if (sLocaleKey.length() == 0) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            aLocale = s_aLocales.get(sLocaleKey);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (aLocale == null) {
            s_aRWLock.writeLock().lock();
            try {
                aLocale = s_aLocales.get(sLocaleKey);
                if (aLocale == null) {
                    aLocale = new Locale(sRealLanguage, sRealCountry, sRealVariant);
                    s_aLocales.put(sLocaleKey, aLocale);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return aLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllLocales() {
        s_aRWLock.readLock().lock();
        try {
            Set<Locale> ret = ContainerHelper.newSet(s_aLocales.values());
            ret.remove(CGlobal.LOCALE_ALL);
            ret.remove(CGlobal.LOCALE_INDEPENDENT);
            Set<Locale> set = ret;
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllLanguages() {
        HashSet<Locale> ret = new HashSet<Locale>();
        for (Locale aLocale : LocaleCache.getAllLocales()) {
            String sLanguage = aLocale.getLanguage();
            if (!StringHelper.hasText(sLanguage)) continue;
            ret.add(LocaleCache.getLocale(sLanguage, null, null));
        }
        return ret;
    }

    public static boolean containsLocale(@Nullable String sLanguage) {
        if (sLanguage != null && sLanguage.length() > 2) {
            String[] aParts = StringHelper.getExplodedArray('_', sLanguage, 3);
            if (aParts.length == 3) {
                return LocaleCache.containsLocale(aParts[0], aParts[1], aParts[2]);
            }
            if (aParts.length == 2) {
                return LocaleCache.containsLocale(aParts[0], aParts[1], "");
            }
        }
        return LocaleCache.containsLocale(sLanguage, "", "");
    }

    public static boolean containsLocale(@Nullable String sLanguage, @Nullable String sCountry) {
        return LocaleCache.containsLocale(sLanguage, sCountry, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsLocale(@Nullable String sLanguage, @Nullable String sCountry, @Nullable String sVariant) {
        String sRealVariant;
        String sRealCountry;
        String sRealLanguage = sLanguage == null ? "" : sLanguage.toLowerCase();
        String sLocaleKey = LocaleCache._buildLocaleString(sRealLanguage, sRealCountry = sCountry == null ? "" : sCountry.toUpperCase(), sRealVariant = sVariant == null ? "" : sVariant);
        if (sLocaleKey.length() == 0) {
            return false;
        }
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aLocales.containsKey(sLocaleKey);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        LocaleCache._initialAdd(CGlobal.LOCALE_ALL);
        LocaleCache._initialAdd(CGlobal.LOCALE_INDEPENDENT);
        for (Locale aLocale : Locale.getAvailableLocales()) {
            LocaleCache._initialAdd(aLocale);
        }
        for (String sCountry : Locale.getISOCountries()) {
            LocaleCache._initialAdd(new Locale("", sCountry));
        }
        for (String sLanguage : Locale.getISOLanguages()) {
            LocaleCache._initialAdd(new Locale(sLanguage, ""));
        }
        s_aInstance = new LocaleCache();
    }
}

