/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mime.EMimeContentType;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MimeType
implements IMimeType {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MimeType.class);
    private final EMimeContentType m_eContentType;
    private final String m_sContentSubType;
    private final String m_sAsString;

    public MimeType(@Nonnull EMimeContentType eContentType, @Nonnull @Nonempty String sContentSubType) {
        if (eContentType == null) {
            throw new NullPointerException("contentType");
        }
        if (StringHelper.hasNoText(sContentSubType)) {
            throw new IllegalArgumentException("contentSubType may not be empty");
        }
        this.m_eContentType = eContentType;
        this.m_sContentSubType = sContentSubType;
        this.m_sAsString = this.m_eContentType.getText() + '/' + this.m_sContentSubType;
    }

    @Override
    @Nonnull
    public EMimeContentType getContentType() {
        return this.m_eContentType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getContentSubType() {
        return this.m_sContentSubType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return this.m_sAsString;
    }

    @Override
    @Nonnull
    public String getAsStringWithEncoding(String sEncoding) {
        return this.m_sAsString + "; charset=" + sEncoding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MimeType)) {
            return false;
        }
        MimeType rhs = (MimeType)o;
        return this.m_eContentType.equals(rhs.m_eContentType) && this.m_sContentSubType.equals(rhs.m_sContentSubType);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eContentType)).append(this.m_sContentSubType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("contentType", this.m_eContentType).append("subType", this.m_sContentSubType).toString();
    }

    @Nullable
    public static IMimeType parseFromStringWithoutEncoding(@Nullable String sMimeType) {
        String sContentType;
        EMimeContentType eContentType;
        int nSlashIndex;
        if (StringHelper.hasText(sMimeType) && (nSlashIndex = sMimeType.indexOf(47)) != -1 && (eContentType = EMimeContentType.getFromIDOrNull(sContentType = sMimeType.substring(0, nSlashIndex))) != null) {
            String sContentSubType = sMimeType.substring(nSlashIndex + 1);
            return new MimeType(eContentType, sContentSubType);
        }
        return null;
    }
}

