/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.ICloneable;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IReadonlyWrapper;
import com.phloc.commons.mutable.IWrapper;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Wrapper<DATATYPE>
implements IWrapper<DATATYPE>,
ICloneable<Wrapper<DATATYPE>> {
    private DATATYPE m_aObj;

    public Wrapper() {
    }

    public Wrapper(@Nullable DATATYPE aObj) {
        this.m_aObj = aObj;
    }

    public Wrapper(@Nonnull IReadonlyWrapper<DATATYPE> rhs) {
        if (rhs == null) {
            throw new NullPointerException("rhs");
        }
        this.m_aObj = rhs.get();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Override
    @Nonnull
    public EChange set(@Nullable DATATYPE aObj) {
        if (EqualsUtils.equals(this.m_aObj, aObj)) {
            return EChange.UNCHANGED;
        }
        this.m_aObj = aObj;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Wrapper<DATATYPE> getClone() {
        return new Wrapper<DATATYPE>(this.m_aObj);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Wrapper rhs = (Wrapper)o;
        return EqualsUtils.equals(this.m_aObj, rhs.m_aObj);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("obj", this.m_aObj).toString();
    }

    @Nonnull
    public static <DATATYPE> Wrapper<DATATYPE> create(@Nullable DATATYPE aObj) {
        return new Wrapper<DATATYPE>(aObj);
    }
}

