/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FilenameAttribute;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidParentException;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.SimpleAttribute;

public class FileResource
extends FramedResource {
    protected static int ATTR_FILENAME = -1;
    protected static int ATTR_FILESTAMP = -1;
    protected static int ATTR_FILE_LENGTH = -1;
    protected static int ATTR_FILE_BACKUP = -1;
    protected File file = null;

    public String getFilename() {
        return (String)this.getValue(ATTR_FILENAME, null);
    }

    public int getFileLength() {
        return (Integer)this.getValue(ATTR_FILE_LENGTH, (Object)new Integer(0));
    }

    public long getFileStamp() {
        return this.getLong(ATTR_FILESTAMP, -1L);
    }

    public boolean getBackupFlag() {
        return this.getBoolean(ATTR_FILE_BACKUP, false);
    }

    public File getBackupFile() {
        File file = this.getFile();
        String string = file.getName();
        return new File(file.getParent(), string + "~");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean newContent(InputStream inputStream) throws IOException {
        File file = this.getFile();
        boolean bl = !file.exists() || file.length() == 0L;
        String string = file.getName();
        File file2 = new File(file.getParent(), "#" + string + "#");
        String string2 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            string2 = iOException.getMessage();
        }
        finally {
            if (string2 != null) {
                file2.delete();
                throw new IOException(string2);
            }
            if (this.getBackupFlag()) {
                File file3 = this.getBackupFile();
                if (file3.exists()) {
                    file3.delete();
                }
                file.renameTo(this.getBackupFile());
            }
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
            this.updateFileAttributes();
        }
        return bl;
    }

    public long checkContent() {
        File file = this.getFile();
        long l = file.lastModified();
        long l2 = this.getFileStamp();
        if (l2 < 0L || l2 < l) {
            this.updateFileAttributes();
            return this.getLastModified();
        }
        if (this.getFileLength() != (int)file.length()) {
            this.updateFileAttributes();
            return this.getLastModified();
        }
        return l2;
    }

    public synchronized void setValue(int n, Object object) {
        if (n == ATTR_IDENTIFIER) {
            File file;
            String string = this.getIdentifier();
            if (this.getFilename() == null && (file = this.getFile(string)) != null && file.exists()) {
                super.setValue(ATTR_FILENAME, (Object)string);
            }
        }
        super.setValue(n, object);
        if (n == ATTR_FILENAME || n == ATTR_IDENTIFIER) {
            this.file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File getFile(String string) {
        ResourceReference resourceReference = this.getParent();
        ResourceReference resourceReference2 = null;
        Resource resource = this;
        while (true) {
            try {
                if (resourceReference == null) {
                    File file = null;
                    return file;
                }
                resource = resourceReference.lock();
                if (resource instanceof DirectoryResource) {
                    DirectoryResource directoryResource = (DirectoryResource)resource;
                    File file = new File(directoryResource.unsafeGetDirectory(), string);
                    return file;
                }
                resourceReference2 = resource.getParent();
            }
            catch (InvalidResourceException invalidResourceException) {
                invalidResourceException.printStackTrace();
                File file = null;
                return file;
            }
            finally {
                if (resourceReference != null) {
                    resourceReference.unlock();
                }
            }
            resourceReference = resourceReference2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File getFile() {
        if (this.file == null) {
            String string = this.getFilename();
            if (string == null) {
                string = this.getIdentifier();
            }
            ResourceReference resourceReference = this.getParent();
            ResourceReference resourceReference2 = null;
            Resource resource = this;
            while (true) {
                try {
                    if (resourceReference == null) {
                        throw new InvalidParentException(resource.getIdentifier() + " can't find his parent, " + "context : " + resource.unsafeGetContext());
                    }
                    resource = resourceReference.lock();
                    if (resource instanceof DirectoryResource) {
                        DirectoryResource directoryResource = (DirectoryResource)resource;
                        File file = this.file = new File(directoryResource.unsafeGetDirectory(), string);
                        return file;
                    }
                    resourceReference2 = resource.getParent();
                }
                catch (InvalidResourceException invalidResourceException) {
                    invalidResourceException.printStackTrace();
                    File file = null;
                    return file;
                }
                finally {
                    if (resourceReference != null) {
                        resourceReference.unlock();
                    }
                }
                resourceReference = resourceReference2;
            }
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verify() throws MultipleLockException {
        File file = this.getFile();
        if (!file.exists()) {
            ResourceReference resourceReference = this.getParent();
            ResourceReference resourceReference2 = null;
            Resource resource = null;
            while (true) {
                try {
                    if (resourceReference == null) {
                        boolean bl = false;
                        return bl;
                    }
                    resource = resourceReference.lock();
                    if (resource instanceof DirectoryResource) {
                        DirectoryResource directoryResource = (DirectoryResource)resource;
                        if (!directoryResource.unsafeGetShrinkableFlag()) {
                            boolean bl = false;
                            return bl;
                        }
                        String string = file + ": deleted, removing the FileResource.";
                        this.getServer().errlog(this, string);
                        this.delete();
                        boolean bl = false;
                        return bl;
                    }
                    resourceReference2 = resource.getParent();
                }
                catch (InvalidResourceException invalidResourceException) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (resourceReference != null) {
                        resourceReference.unlock();
                    }
                }
                resourceReference = resourceReference2;
            }
        }
        return true;
    }

    public void updateFileAttributes() {
        File file = this.getFile();
        this.setValue(ATTR_FILESTAMP, (Object)new Long(file.lastModified()));
        this.setValue(ATTR_FILE_LENGTH, (Object)new Integer((int)file.length()));
    }

    public void updateAttributes() {
        long l = this.getFile().lastModified();
        long l2 = this.getLong(ATTR_FILESTAMP, -1L);
        if (l2 < 0L || l2 != l) {
            this.updateFileAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object[] objectArray) {
        ResourceReference resourceReference;
        super.initialize(objectArray);
        this.disableEvent();
        String string = this.getFilename();
        if (string != null && (resourceReference = this.getParent()) != null) {
            try {
                Resource resource = resourceReference.unsafeLock();
                this.setValue(ATTR_URL, (Object)(resource.unsafeGetURLPath() + URLEncoder.encode(this.getIdentifier())));
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                resourceReference.unlock();
            }
        }
        this.enableEvent();
    }

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.FileResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        simpleAttribute = new FilenameAttribute("filename", (Object)null, 2);
        ATTR_FILENAME = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new DateAttribute("file-stamp", (Object)new Long(-1L), 1);
        ATTR_FILESTAMP = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("file-length", null, 1);
        ATTR_FILE_LENGTH = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("backup", Boolean.FALSE, 2);
        ATTR_FILE_BACKUP = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }
}

