/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.callback;

import com.phloc.commons.callback.INonThrowingCallable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AdapterRunnableToCallable<DATATYPE>
implements INonThrowingCallable<DATATYPE> {
    private final Runnable m_aRunnable;
    private final DATATYPE m_aResult;

    public AdapterRunnableToCallable(@Nonnull Runnable aRunnable) {
        this(aRunnable, null);
    }

    public AdapterRunnableToCallable(@Nonnull Runnable aRunnable, @Nullable DATATYPE aResult) {
        if (aRunnable == null) {
            throw new NullPointerException("runnable");
        }
        this.m_aRunnable = aRunnable;
        this.m_aResult = aResult;
    }

    @Override
    @Nullable
    public DATATYPE call() {
        this.m_aRunnable.run();
        return this.m_aResult;
    }

    @Nonnull
    public static AdapterRunnableToCallable<Object> createAdapter(@Nonnull Runnable aRunnable) {
        return new AdapterRunnableToCallable<Object>(aRunnable);
    }

    @Nonnull
    public static <DATATYPE> AdapterRunnableToCallable<DATATYPE> createAdapter(@Nonnull Runnable aRunnable, @Nullable DATATYPE aResult) {
        return new AdapterRunnableToCallable<DATATYPE>(aRunnable, aResult);
    }
}

