/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResourceLocation
implements IResourceLocation {
    private final String m_sResourceID;
    private final int m_nLineNumber;
    private final int m_nColumnNumber;
    private final String m_sField;

    public ResourceLocation(@Nullable String sResourceID) {
        this(sResourceID, null);
    }

    public ResourceLocation(@Nullable String sResourceID, @Nullable String sField) {
        this(sResourceID, -1, -1, sField);
    }

    public ResourceLocation(@Nullable String sResourceID, int nLineNumber, int nColumnNumber) {
        this(sResourceID, nLineNumber, nColumnNumber, null);
    }

    public ResourceLocation(@Nullable String sResourceID, int nLineNumber, int nColumnNumber, @Nullable String sField) {
        this.m_sResourceID = sResourceID;
        this.m_nLineNumber = nLineNumber;
        this.m_nColumnNumber = nColumnNumber;
        this.m_sField = sField;
    }

    @Override
    @Nullable
    public String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    public int getLineNumber() {
        return this.m_nLineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.m_nColumnNumber;
    }

    @Override
    @Nullable
    public String getField() {
        return this.m_sField;
    }

    @Override
    @Nonnull
    public String getAsString() {
        String ret = "";
        if (this.m_sResourceID != null) {
            ret = ret + this.m_sResourceID;
        }
        if (this.m_nLineNumber != -1) {
            ret = this.m_nColumnNumber != -1 ? ret + "(" + this.m_nLineNumber + ":" + this.m_nColumnNumber + ")" : ret + "(" + this.m_nLineNumber + ":?)";
        }
        if (this.m_sField != null) {
            if (ret.length() > 0) {
                ret = ret + " @ ";
            }
            ret = ret + this.m_sField;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation rhs = (ResourceLocation)o;
        return EqualsUtils.equals(this.m_sResourceID, rhs.m_sResourceID) && this.m_nLineNumber == rhs.m_nLineNumber && this.m_nColumnNumber == rhs.m_nColumnNumber && EqualsUtils.equals(this.m_sField, rhs.m_sField);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sResourceID).append(this.m_nLineNumber).append(this.m_nColumnNumber).append(this.m_sField).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("resourceID", this.m_sResourceID).append("lineNumber", this.m_nLineNumber).append("columnNumber", this.m_nColumnNumber).appendIfNotNull("field", this.m_sField).toString();
    }
}

