/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingByteArrayOutputStream
extends OutputStream
implements IHasSize,
Serializable {
    protected byte[] m_aBuf;
    protected int m_nCount;

    public NonBlockingByteArrayOutputStream() {
        this(32);
    }

    public NonBlockingByteArrayOutputStream(@Nonnegative int nSize) {
        if (nSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + nSize);
        }
        this.m_aBuf = new byte[nSize];
    }

    @Nonnull
    private static byte[] _enlarge(@Nonnull byte[] aBuf, @Nonnegative int nNewSize) {
        byte[] ret = new byte[nNewSize];
        System.arraycopy(aBuf, 0, ret, 0, aBuf.length);
        return ret;
    }

    @Override
    public void write(int b) {
        int nNewCount = this.m_nCount + 1;
        if (nNewCount > this.m_aBuf.length) {
            this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, nNewCount));
        }
        this.m_aBuf[this.m_nCount] = (byte)b;
        this.m_nCount = nNewCount;
    }

    @Override
    public void write(@Nonnull byte[] aBuf) {
        this.write(aBuf, 0, aBuf.length);
    }

    @Override
    public void write(@Nonnull byte[] aBuf, int nOfs, int nLen) {
        if (aBuf == null) {
            throw new NullPointerException("buf");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuf.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuf.length);
        }
        if (nLen > 0) {
            int nNewCount = this.m_nCount + nLen;
            if (nNewCount > this.m_aBuf.length) {
                this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, nNewCount));
            }
            System.arraycopy(aBuf, nOfs, this.m_aBuf, this.m_nCount, nLen);
            this.m_nCount = nNewCount;
        }
    }

    public void writeTo(@Nonnull OutputStream out) throws IOException {
        out.write(this.m_aBuf, 0, this.m_nCount);
    }

    public void reset() {
        this.m_nCount = 0;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] toByteArray() {
        return ArrayHelper.getCopy(this.m_aBuf, this.m_nCount);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_nCount;
    }

    @Nonnegative
    public int getBufferSize() {
        return this.m_aBuf.length;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nCount == 0;
    }

    @Nonnull
    public String getAsString(@Nonnull String sCharset) {
        return CharsetManager.getAsString(this.m_aBuf, 0, this.m_nCount, sCharset);
    }

    @Nonnull
    public String getAsString(@Nonnull Charset aCharset) {
        return CharsetManager.getAsString(this.m_aBuf, 0, this.m_nCount, aCharset);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return new ToStringGenerator(this).append("buf#", ArrayHelper.getSize(this.m_aBuf)).append("size", this.m_nCount).toString();
    }
}

