/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassHelper {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new WeakHashMap(8);
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new WeakHashMap(8);
    private static final ClassHelper s_aInstance;

    private static void _registerPrimitiveMapping(@Nonnull Class<?> aPrimitiveType, @Nonnull Class<?> aPrimitiveWrapperType) {
        PRIMITIVE_TO_WRAPPER.put(aPrimitiveType, aPrimitiveWrapperType);
        WRAPPER_TO_PRIMITIVE.put(aPrimitiveWrapperType, aPrimitiveType);
    }

    private ClassHelper() {
    }

    @Nonnull
    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    @Nonnull
    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Nonnull
    public static ClassLoader getClassClassLoader(final @Nonnull Class<?> aClass) {
        if (System.getSecurityManager() == null) {
            return aClass.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return aClass.getClassLoader();
            }
        });
    }

    @Nonnull
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader ret = null;
        try {
            ret = ClassHelper.getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            ret = ClassHelper.getClassClassLoader(ClassHelper.class);
        }
        return ret;
    }

    public static boolean isPublicClass(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.isInterface() || aClass.isAnnotation()) {
            return false;
        }
        if (!ClassHelper.isPublic(aClass)) {
            return false;
        }
        return !ClassHelper.isAbstractClass(aClass);
    }

    public static boolean isInstancableClass(@Nullable Class<?> aClass) {
        if (!ClassHelper.isPublicClass(aClass)) {
            return false;
        }
        try {
            aClass.getConstructor(null);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }

    public static boolean isPublic(@Nullable Class<?> aClass) {
        return aClass != null && Modifier.isPublic(aClass.getModifiers());
    }

    public static boolean isInterface(@Nullable Class<?> aClass) {
        return aClass != null && Modifier.isInterface(aClass.getModifiers());
    }

    public static boolean isAnnotationClass(@Nullable Class<?> aClass) {
        return aClass != null && aClass.isAnnotation();
    }

    public static boolean isEnumClass(@Nullable Class<?> aClass) {
        return aClass != null && aClass.isEnum();
    }

    public static boolean isAbstractClass(@Nullable Class<?> aClass) {
        return aClass != null && !aClass.isArray() && Modifier.isAbstract(aClass.getModifiers());
    }

    public static boolean isArrayClass(@Nullable Class<?> aClass) {
        return aClass != null && aClass.isArray();
    }

    public static boolean isPrimitiveType(@Nullable Class<?> aClass) {
        return aClass != null && PRIMITIVE_TO_WRAPPER.containsKey(aClass);
    }

    public static boolean isPrimitiveWrapperType(@Nullable Class<?> aClass) {
        return aClass != null && WRAPPER_TO_PRIMITIVE.containsKey(aClass);
    }

    @Nullable
    public static Class<?> getPrimitiveWrapperClass(@Nullable Class<?> aClass) {
        if (ClassHelper.isPrimitiveWrapperType(aClass)) {
            return aClass;
        }
        return PRIMITIVE_TO_WRAPPER.get(aClass);
    }

    @Nullable
    public static Class<?> getPrimitiveClass(@Nullable Class<?> aClass) {
        if (ClassHelper.isPrimitiveType(aClass)) {
            return aClass;
        }
        return WRAPPER_TO_PRIMITIVE.get(aClass);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Class<?>> getAllPrimitiveClasses() {
        return ContainerHelper.makeUnmodifiable(PRIMITIVE_TO_WRAPPER.keySet());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Class<?>> getAllPrimitiveWrapperClasses() {
        return ContainerHelper.makeUnmodifiable(WRAPPER_TO_PRIMITIVE.keySet());
    }

    public static boolean isStringClass(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(aClass);
    }

    public static boolean isCharacterClass(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        return Character.class.isAssignableFrom(aClass) || Character.TYPE.isAssignableFrom(aClass);
    }

    public static boolean isBooleanClass(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(aClass) || Boolean.TYPE.isAssignableFrom(aClass);
    }

    public static boolean isFloatingPointClass(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        return Double.class.isAssignableFrom(aClass) || Double.TYPE.isAssignableFrom(aClass) || Float.class.isAssignableFrom(aClass) || Float.TYPE.isAssignableFrom(aClass) || BigDecimal.class.isAssignableFrom(aClass);
    }

    public static boolean isIntegerClass(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        return Byte.class.isAssignableFrom(aClass) || Byte.TYPE.isAssignableFrom(aClass) || Integer.class.isAssignableFrom(aClass) || Integer.TYPE.isAssignableFrom(aClass) || Long.class.isAssignableFrom(aClass) || Long.TYPE.isAssignableFrom(aClass) || Short.class.isAssignableFrom(aClass) || Short.TYPE.isAssignableFrom(aClass) || BigInteger.class.isAssignableFrom(aClass);
    }

    @Nonnull
    @Deprecated
    @ReturnsMutableCopy
    public static Set<Class<?>> getClassHierarchy(@Nonnull Class<?> aClass) {
        return ClassHierarchyCache.getClassHierarchy(aClass);
    }

    @Deprecated
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static Collection<Class<?>> getClassHierarchy(@Nonnull Class<?> aClass, boolean bUniqueClasses) {
        return ClassHelper.getClassHierarchy(aClass);
    }

    public static boolean areConvertibleClasses(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass) {
        if (aSrcClass == null) {
            throw new NullPointerException("srcClass");
        }
        if (aDstClass == null) {
            throw new NullPointerException("dstClass");
        }
        if (aDstClass.equals(aSrcClass)) {
            return true;
        }
        if (aDstClass.isAssignableFrom(aSrcClass)) {
            return true;
        }
        if (aDstClass == ClassHelper.getPrimitiveWrapperClass(aSrcClass)) {
            return true;
        }
        return aDstClass == ClassHelper.getPrimitiveClass(aSrcClass);
    }

    static {
        ClassHelper._registerPrimitiveMapping(Boolean.TYPE, Boolean.class);
        ClassHelper._registerPrimitiveMapping(Byte.TYPE, Byte.class);
        ClassHelper._registerPrimitiveMapping(Character.TYPE, Character.class);
        ClassHelper._registerPrimitiveMapping(Double.TYPE, Double.class);
        ClassHelper._registerPrimitiveMapping(Float.TYPE, Float.class);
        ClassHelper._registerPrimitiveMapping(Integer.TYPE, Integer.class);
        ClassHelper._registerPrimitiveMapping(Long.TYPE, Long.class);
        ClassHelper._registerPrimitiveMapping(Short.TYPE, Short.class);
        s_aInstance = new ClassHelper();
    }
}

