/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert;

import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterProvider;
import com.phloc.commons.typeconvert.TypeConverterException;
import com.phloc.commons.typeconvert.TypeConverterProviderBestMatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TypeConverter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(TypeConverter.class);
    private static final TypeConverter s_aInstance = new TypeConverter();

    private TypeConverter() {
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(boolean aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(aSrcValue, aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(byte aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(aSrcValue, aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(char aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(Character.valueOf(aSrcValue), aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(double aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(aSrcValue, aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(float aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(Float.valueOf(aSrcValue), aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(int aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(aSrcValue, aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(long aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(aSrcValue, aDstClass);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convert(short aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(aSrcValue, aDstClass);
    }

    public static boolean convertToBoolean(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Boolean.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Boolean aValue = TypeConverter.convertIfNecessary(aSrcValue, Boolean.class);
        return aValue;
    }

    public static byte convertToByte(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Byte.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Byte aValue = TypeConverter.convertIfNecessary(aSrcValue, Byte.class);
        return aValue;
    }

    public static char convertToChar(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Character.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Character aValue = TypeConverter.convertIfNecessary(aSrcValue, Character.class);
        return aValue.charValue();
    }

    public static double convertToDouble(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Double.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Double aValue = TypeConverter.convertIfNecessary(aSrcValue, Double.class);
        return aValue;
    }

    public static float convertToFloat(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Float.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Float aValue = TypeConverter.convertIfNecessary(aSrcValue, Float.class);
        return aValue.floatValue();
    }

    public static int convertToInt(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Integer.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Integer aValue = TypeConverter.convertIfNecessary(aSrcValue, Integer.class);
        return aValue;
    }

    public static long convertToLong(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Long.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Long aValue = TypeConverter.convertIfNecessary(aSrcValue, Long.class);
        return aValue;
    }

    public static short convertToShort(@Nonnull Object aSrcValue) {
        if (aSrcValue == null) {
            throw new TypeConverterException(Short.TYPE, TypeConverterException.EReason.NULL_SOURCE_NOT_ALLOWED);
        }
        Short aValue = TypeConverter.convertIfNecessary(aSrcValue, Short.class);
        return aValue;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertIfNecessary(@Nullable Object aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) {
        return TypeConverter.convertIfNecessary(TypeConverterProviderBestMatch.getInstance(), aSrcValue, aDstClass);
    }

    @Nullable
    private static Class<?> _getUsableClass(@Nullable Class<?> aClass) {
        Class<?> aPrimitiveWrapperType = ClassHelper.getPrimitiveWrapperClass(aClass);
        return aPrimitiveWrapperType != null ? aPrimitiveWrapperType : aClass;
    }

    @Nonnull
    private static Object _performConversion(@Nonnull ITypeConverterProvider aTypeConverterProvider, @Nonnull Class<?> aSrcClass, @Nonnull Class<?> aUsableDstClass, @Nonnull Object aSrcValue) throws TypeConverterException {
        ITypeConverter aConverter = aTypeConverterProvider.getTypeConverter(aSrcClass, aUsableDstClass);
        if (aConverter == null) {
            s_aLogger.warn("No type converter from '" + aSrcClass.getName() + "' to '" + aUsableDstClass.getName() + "' was found");
            throw new TypeConverterException(aSrcClass, aUsableDstClass, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        Object aRetVal = aConverter.convert(aSrcValue);
        if (aRetVal == null) {
            s_aLogger.warn("Type conversion from '" + aSrcValue + "' of class '" + aSrcClass.getName() + "' to '" + aUsableDstClass.getName() + "' with converter " + aConverter + " failed");
            throw new TypeConverterException(aSrcClass, aUsableDstClass, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return aRetVal;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertIfNecessary(@Nonnull ITypeConverterProvider aTypeConverterProvider, @Nullable Object aSrcValue, @Nonnull Class<DSTTYPE> aDstClass) throws TypeConverterException {
        Class<?> aUsableDstClass;
        if (aTypeConverterProvider == null) {
            throw new NullPointerException("typeConverterProvider");
        }
        if (aDstClass == null) {
            throw new NullPointerException("destClass");
        }
        if (aSrcValue == null) {
            return null;
        }
        Class<?> aSrcClass = aSrcValue.getClass();
        Object aRetVal = ClassHelper.areConvertibleClasses(aSrcClass, aUsableDstClass = TypeConverter._getUsableClass(aDstClass)) ? aSrcValue : TypeConverter._performConversion(aTypeConverterProvider, aSrcClass, aUsableDstClass, aSrcValue);
        Object ret = aRetVal;
        return (DSTTYPE)ret;
    }
}

