/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.IllegalAttributeAccess;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.event.StructureChangedEvent;
import org.w3c.tools.resources.indexer.IndexerModule;
import org.w3c.tools.resources.indexer.ResourceIndexer;

public class DirectoryResource
extends ContainerResource {
    protected static int ATTR_DIRECTORY = -1;
    protected static int ATTR_DIRSTAMP = -1;
    protected static int ATTR_INDEXER = -1;
    protected static int ATTR_EXTENSIBLE = -1;
    protected static int ATTR_SHRINKABLE = -1;
    static String di = "directory".intern();

    protected ResourceReference getIndexer(ResourceContext resourceContext) {
        IndexerModule indexerModule = (IndexerModule)resourceContext.getModule(IndexerModule.NAME);
        ResourceReference resourceReference = indexerModule.getIndexer(resourceContext);
        return resourceReference;
    }

    public void setValue(int n, Object object) {
        String string;
        super.setValue(n, object);
        if (n == ATTR_INDEXER && (string = this.getString(ATTR_INDEXER, null)) != null) {
            ResourceContext resourceContext = null;
            IndexerModule indexerModule = null;
            resourceContext = this.getContext();
            indexerModule = (IndexerModule)resourceContext.getModule(IndexerModule.NAME);
            indexerModule.registerIndexer(resourceContext, string);
        }
    }

    public File getDirectory() {
        return (File)this.getValue(ATTR_DIRECTORY, null);
    }

    public File unsafeGetDirectory() {
        return (File)this.unsafeGetValue(ATTR_DIRECTORY, null);
    }

    public long getDirStamp() {
        return this.getLong(ATTR_DIRSTAMP, -1L);
    }

    public boolean getExtensibleFlag() {
        return this.getBoolean(ATTR_EXTENSIBLE, true);
    }

    public boolean getShrinkableFlag() {
        return this.getBoolean(ATTR_SHRINKABLE, true);
    }

    public boolean unsafeGetShrinkableFlag() {
        Object object = this.unsafeGetValue(ATTR_SHRINKABLE, null);
        if (object == null) {
            return true;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalAttributeAccess((AttributeHolder)this, this.attributes[ATTR_SHRINKABLE], "getBoolean");
    }

    public void resourceRemoved(StructureChangedEvent structureChangedEvent) {
        super.resourceRemoved(structureChangedEvent);
        if (!this.isUnloaded()) {
            this.markModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceReference createDirectoryResource(String string) {
        ResourceReference resourceReference;
        block18: {
            File file = new File(this.getDirectory(), string);
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (file.exists()) {
                    if (!file.isDirectory()) {
                        bl = false;
                    } else {
                        bl2 = true;
                    }
                } else {
                    file.mkdir();
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) {
                return null;
            }
            resourceReference = this.createDefaultResource(string);
            if (resourceReference == null) {
                if (!bl2) {
                    file.delete();
                }
                return null;
            }
            try {
                Resource resource = resourceReference.lock();
                if (resource instanceof DirectoryResource) break block18;
                try {
                    resource.delete();
                }
                catch (MultipleLockException multipleLockException) {
                    // empty catch block
                }
                if (!bl2) {
                    file.delete();
                }
                ResourceReference resourceReference2 = null;
                return resourceReference2;
            }
            catch (InvalidResourceException invalidResourceException) {
                if (!bl2) {
                    file.delete();
                }
                ResourceReference resourceReference3 = null;
                return resourceReference3;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return resourceReference;
    }

    public ResourceReference createResource(String string) {
        return this.createResource(string, null);
    }

    public ResourceReference createResource(String string, RequestInterface requestInterface) {
        File file = new File(this.getDirectory(), string);
        boolean bl = false;
        if (!file.exists()) {
            try {
                new RandomAccessFile(file, "rw").close();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl) {
            return null;
        }
        ResourceReference resourceReference = this.createDefaultResource(string, requestInterface);
        file.delete();
        return resourceReference;
    }

    private Resource index(String string, Hashtable hashtable) {
        return this.index(string, hashtable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource index(String string, Hashtable hashtable, RequestInterface requestInterface) {
        hashtable.put(id, string);
        this.updateDefaultChildAttributes(hashtable);
        ResourceContext resourceContext = this.getContext();
        Resource resource = null;
        ResourceReference resourceReference = null;
        ResourceReference resourceReference2 = null;
        while (resourceContext != null) {
            do {
                resourceReference = this.getIndexer(resourceContext);
                resourceContext = resourceContext.getParent();
            } while (resourceReference == resourceReference2 && resourceContext != null);
            resourceReference2 = resourceReference;
            if (resourceReference2 == null) continue;
            try {
                ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
                resource = resourceIndexer.createResource(this, requestInterface, this.getDirectory(), string, hashtable);
                if (resource == null) continue;
                break;
            }
            catch (InvalidResourceException invalidResourceException) {
                resource = null;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIndexedName(String string) {
        ResourceContext resourceContext = this.getContext();
        String string2 = null;
        ResourceReference resourceReference = null;
        ResourceReference resourceReference2 = null;
        while (resourceContext != null) {
            do {
                resourceReference = this.getIndexer(resourceContext);
                resourceContext = resourceContext.getParent();
            } while (resourceReference == resourceReference2 && resourceContext != null);
            resourceReference2 = resourceReference;
            if (resourceReference2 == null) continue;
            try {
                ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
                string2 = resourceIndexer.getIndexedName(this.getDirectory(), string);
                if (string2 == null) continue;
                break;
            }
            catch (InvalidResourceException invalidResourceException) {
                string2 = null;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return string2 == null ? string : string2;
    }

    public synchronized ResourceReference createDefaultResource(String string) {
        return this.createDefaultResource(string, null);
    }

    protected synchronized ResourceReference createDefaultResource(String string, RequestInterface requestInterface) {
        if (string.equals("..") || string.equals(".") || string.indexOf(92) >= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable(10);
        Resource resource = this.index(string, hashtable, requestInterface);
        ResourceReference resourceReference = null;
        if (resource != null) {
            resourceReference = this.addResource(resource, hashtable);
            this.markModified();
        }
        return resourceReference;
    }

    protected ResourceContext updateDefaultChildAttributes(Hashtable hashtable) {
        ResourceContext resourceContext = null;
        resourceContext = super.updateDefaultChildAttributes(hashtable);
        String string = (String)hashtable.get(id);
        if (string != null && this.getDirectory() != null) {
            hashtable.put(di, new File(this.getDirectory(), string));
        }
        return resourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reindex(boolean bl) {
        if (this.getExtensibleFlag()) {
            Enumeration enumeration = this.enumerateAllResourceIdentifiers();
            String string = null;
            ResourceReference resourceReference = null;
            Resource resource = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                resourceReference = this.lookup(string);
                if (resourceReference == null) continue;
                try {
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    resource = resourceReference.lock();
                    if (resource == this) continue;
                    if (resource instanceof DirectoryResource) {
                        cloneable2 = (DirectoryResource)resource;
                        cloneable = new Hashtable<String, ResourceContext>(5);
                        cloneable.put(co, ((Resource)cloneable2).getContext());
                        Resource resource2 = this.index(string, (Hashtable)cloneable);
                        if (resource2 == null && bl) {
                            ((DirectoryResource)cloneable2).reindex(true);
                            continue;
                        }
                        if (!(resource2 instanceof DirectoryResource)) {
                            throw new RuntimeException("Reindex Error : " + string + " can't be reindexed. " + "The reindexed resource is " + "no more a DirectoryResource.");
                        }
                        DirectoryResource directoryResource = (DirectoryResource)resource2;
                        String string2 = directoryResource.getString(ATTR_INDEXER, "");
                        if (string2.equals("")) {
                            if (bl) {
                                ((DirectoryResource)cloneable2).reindex(true);
                            }
                            string2 = ((AttributeHolder)cloneable2).getString(ATTR_INDEXER, null);
                            directoryResource.setValue(ATTR_INDEXER, (Object)string2);
                        } else {
                            ((DirectoryResource)cloneable2).setValue(ATTR_INDEXER, string2);
                            if (bl) {
                                ((DirectoryResource)cloneable2).reindex(true);
                            }
                        }
                        directoryResource.setValue(ATTR_KEY, (Object)((ContainerResource)cloneable2).getKey());
                        ((DirectoryResource)cloneable2).setValue(ATTR_IDENTIFIER, string + "-bakindex");
                        this.addResource(directoryResource, (Hashtable)cloneable);
                        try {
                            ((ContainerResource)cloneable2).replace(directoryResource);
                            continue;
                        }
                        catch (MultipleLockException multipleLockException) {
                            throw new RuntimeException("Reindex Error : " + multipleLockException.getMessage());
                        }
                    }
                    if (resource instanceof AbstractContainer || (cloneable = this.index(string, (Hashtable)(cloneable2 = new Hashtable(10)))) == null) continue;
                    try {
                        resource.delete();
                    }
                    catch (MultipleLockException multipleLockException) {
                        throw new RuntimeException("Reindex Error : " + multipleLockException.getMessage());
                    }
                    this.addResource((Resource)cloneable, (Hashtable)cloneable2);
                }
                catch (InvalidResourceException invalidResourceException) {
                    System.out.println(invalidResourceException.getMessage());
                }
                finally {
                    resourceReference.unlock();
                }
            }
            this.markModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Enumeration enumerateAllResourceIdentifiers() {
        File file = this.getDirectory();
        if (file != null) {
            DirectoryResource directoryResource = this;
            synchronized (directoryResource) {
                String[] stringArray = file.list();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals(".") || stringArray[i].equals("..") || super.lookup(stringArray[i]) != null) continue;
                        String string = this.getIndexedName(stringArray[i]);
                        if (string.equals(stringArray[i])) {
                            this.createDefaultResource(stringArray[i]);
                            continue;
                        }
                        if (super.lookup(string) != null) continue;
                        this.createDefaultResource(stringArray[i]);
                    }
                }
            }
        }
        return super.enumerateResourceIdentifiers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration enumerateResourceIdentifiers(boolean bl) {
        File file;
        if (bl && this.getExtensibleFlag() && (file = this.getDirectory()) != null) {
            DirectoryResource directoryResource = this;
            synchronized (directoryResource) {
                long l = file.lastModified();
                if (l > this.getDirStamp()) {
                    String[] stringArray = file.list();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].equals(".") || stringArray[i].equals("..") || super.lookup(stringArray[i]) != null) continue;
                            String string = this.getIndexedName(stringArray[i]);
                            if (string.equals(stringArray[i])) {
                                this.createDefaultResource(stringArray[i]);
                                continue;
                            }
                            if (super.lookup(string) != null) continue;
                            this.createDefaultResource(stringArray[i]);
                        }
                    }
                    this.setLong(ATTR_DIRSTAMP, l);
                }
            }
        }
        return super.enumerateResourceIdentifiers(bl);
    }

    public ResourceReference lookup(String string) {
        ResourceReference resourceReference = null;
        resourceReference = super.lookup(string);
        if (resourceReference != null) {
            return resourceReference;
        }
        return this.getExtensibleFlag() ? this.createDefaultResource(string) : null;
    }

    public synchronized void delete() throws MultipleLockException {
        this.disableEvent();
        this.setBoolean(ATTR_EXTENSIBLE, false);
        super.delete();
    }

    public synchronized boolean verify() {
        return this.getDirectory().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void initialize(Object[] var1_1) {
        super.initialize(var1_1);
        this.disableEvent();
        var2_2 = null;
        if (!this.definesAttribute(DirectoryResource.ATTR_DIRECTORY)) {
            var3_3 = this.getParent();
            if (var3_3 != null) {
                try {
                    var4_4 = var3_3.lock();
                    if (!var4_4.definesAttribute(DirectoryResource.di) || (var5_6 = (File)var4_4.getValue(DirectoryResource.di, null)) == null) ** GOTO lbl20
                    var2_2 = new File((File)var5_6, this.getIdentifier());
                    this.setValue(DirectoryResource.ATTR_DIRECTORY, (Object)var2_2);
                }
                catch (InvalidResourceException var4_5) {
                }
                finally {
                    var3_3.unlock();
                }
            }
        } else {
            var2_2 = this.getDirectory();
        }
lbl20:
        // 5 sources

        var3_3 = this.getContext();
        var4_4 = this.getString(DirectoryResource.ATTR_INDEXER, null);
        if (var4_4 != null && !var4_4.equals("")) {
            var5_6 = (IndexerModule)var3_3.getModule(IndexerModule.NAME);
            var5_6.registerIndexer((ResourceContext)var3_3, (String)var4_4);
        }
        this.enableEvent();
    }

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.DirectoryResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new FileAttribute("directory", null, 9);
        ATTR_DIRECTORY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new DateAttribute("dirstamp", (Object)null, 1);
        ATTR_DIRSTAMP = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new StringAttribute("indexer", null, 2);
        ATTR_INDEXER = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("extensible", Boolean.TRUE, 2);
        ATTR_EXTENSIBLE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("shrinkable", Boolean.TRUE, 2);
        ATTR_SHRINKABLE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }
}

