/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.w3c.tools.widgets.ImageCache;

public class ImageButton
extends Canvas {
    protected boolean switchable = false;
    protected Image img1 = null;
    protected Image img2 = null;
    protected Image currentImg = null;
    private int width = -1;
    private int height = -1;
    private String command;
    transient ActionListener actionListener;

    int max(int n, int n2) {
        return n < n2 ? n2 : n;
    }

    protected void initSize() {
        if (this.switchable) {
            this.width = this.max(this.img1.getWidth(this), this.img2.getWidth(this));
            this.height = this.max(this.img1.getHeight(this), this.img2.getHeight(this));
        } else {
            this.width = this.currentImg.getWidth(this);
            this.height = this.currentImg.getHeight(this);
        }
    }

    public void switchImage() {
        if (this.switchable) {
            this.currentImg = this.currentImg == this.img1 ? this.img2 : this.img1;
        }
        this.paintShadow(true);
    }

    public void paint(Graphics graphics) {
        this.paintShadow(true);
    }

    protected void paintShadow(boolean bl) {
        Graphics graphics = this.getGraphics();
        Shape shape = graphics.getClip();
        Color color = this.getBackground();
        Dimension dimension = this.getSize();
        Image image = ImageCache.getImage(this, dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setClip(shape);
        graphics2.setColor(color);
        int n = dimension.width - this.width;
        int n2 = dimension.height - this.height;
        graphics2.clearRect(0, 0, dimension.width, dimension.height);
        graphics2.fill3DRect(1, 1, dimension.width - 2, dimension.height - 2, bl);
        graphics2.drawImage(this.currentImg, n / 2, n2 / 2, this);
        graphics.drawImage(image, 0, 0, this);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.initSize();
        Container container = this.getParent();
        if (container != null) {
            container.doLayout();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width + 8, this.height + 8);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width + 8, this.height + 8);
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public String getActionCommand() {
        return this.command;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void fireActionEvent() {
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.command);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public ImageButton(Image image, Image image2, String string) {
        this.switchable = true;
        this.img1 = image;
        this.img2 = image2;
        this.currentImg = image;
        this.command = string;
        this.addMouseListener(new ImageButtonListener());
        this.prepareImage(image, this);
        this.prepareImage(image2, this);
        this.initSize();
    }

    public ImageButton(Image image, Image image2) {
        this(image, image2, "");
    }

    public ImageButton(Image image, String string) {
        this.switchable = false;
        this.currentImg = image;
        this.command = string;
        this.addMouseListener(new ImageButtonListener());
        this.prepareImage(this.currentImg, this);
        this.initSize();
    }

    public ImageButton(Image image) {
        this(image, "");
    }

    private class ImageButtonListener
    extends MouseAdapter {
        private ImageButtonListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ImageButton.this.paintShadow(false);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageButton.this.paintShadow(true);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ImageButton.this.fireActionEvent();
        }
    }
}

