/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.system.JavaVersionConstants;
import javax.annotation.Nonnull;

public enum EJavaVersion {
    UNKNOWN,
    JDK_11(45.3, 46.0),
    JDK_12(46.0, 47.0),
    JDK_13(47.0, 48.0),
    JDK_14(48.0, 49.0),
    JDK_15(49.0, 50.0),
    JDK_16(50.0, 51.0),
    JDK_17(51.0, 52.0);

    private static volatile EJavaVersion s_aInstance;
    private final double m_dMinVersionIncl;
    private final double m_dMaxVersionExcl;
    private final boolean m_bIsIt;

    private EJavaVersion() {
        this.m_dMinVersionIncl = Double.NaN;
        this.m_dMaxVersionExcl = Double.NaN;
        this.m_bIsIt = EqualsUtils.equals(Double.NaN, JavaVersionConstants.CLASS_VERSION);
    }

    private EJavaVersion(double dMinVersionIncl, double dMaxVersionExcl) {
        this.m_dMinVersionIncl = dMinVersionIncl;
        this.m_dMaxVersionExcl = dMaxVersionExcl;
        this.m_bIsIt = this.isMatchingVersion(JavaVersionConstants.CLASS_VERSION);
    }

    protected boolean isMatchingVersion(double dVersion) {
        return dVersion >= this.m_dMinVersionIncl && dVersion < this.m_dMaxVersionExcl;
    }

    public boolean isCurrentVersion() {
        return this.m_bIsIt;
    }

    public boolean isSupportedVersion() {
        return this.m_dMinVersionIncl < EJavaVersion.getCurrentVersion().m_dMaxVersionExcl;
    }

    @Nonnull
    static EJavaVersion getCurrentVersion() {
        EJavaVersion ret = s_aInstance;
        if (ret == null) {
            for (EJavaVersion eVersion : EJavaVersion.values()) {
                if (!eVersion.m_bIsIt) continue;
                ret = eVersion;
                break;
            }
            if (ret == null) {
                ret = UNKNOWN;
            }
            s_aInstance = ret;
        }
        return ret;
    }

    @Nonnull
    public static EJavaVersion getFromMajorAndMinor(int nMajor, int nMinor) {
        double dVersion = StringParser.parseBigDecimal(nMajor + "." + nMinor).doubleValue();
        return EJavaVersion.getFromVersionNumber(dVersion);
    }

    @Nonnull
    public static EJavaVersion getFromVersionNumber(double dVersion) {
        for (EJavaVersion eVersion : EJavaVersion.values()) {
            if (!eVersion.isMatchingVersion(dVersion)) continue;
            return eVersion;
        }
        return UNKNOWN;
    }

    static {
        s_aInstance = null;
    }
}

