/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.multimap.IMultiMapListBased;
import com.phloc.commons.collections.multimap.MultiTreeMapArrayListBased;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.mutable.Wrapper;
import com.phloc.commons.state.EContinue;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterCallback;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.ITypeConverterRule;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TypeConverterRegistry
implements ITypeConverterRegistry {
    private static final TypeConverterRegistry s_aInstance = new TypeConverterRegistry();
    private static final Logger s_aLogger = LoggerFactory.getLogger(TypeConverterRegistry.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<Class<?>, Map<Class<?>, ITypeConverter>> s_aConverter = new WeakHashMap();
    private static final IMultiMapListBased<ITypeConverterRule.ESubType, ITypeConverterRule> s_aRules = new MultiTreeMapArrayListBased<ITypeConverterRule.ESubType, ITypeConverterRule>();

    private TypeConverterRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static Map<Class<?>, ITypeConverter> _getOrCreateConverterMap(@Nonnull Class<?> aClass) {
        Map<Class<?>, ITypeConverter> ret;
        s_aRWLock.readLock().lock();
        try {
            ret = s_aConverter.get(aClass);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (ret == null) {
            s_aRWLock.writeLock().lock();
            try {
                ret = s_aConverter.get(aClass);
                if (ret == null) {
                    ret = new WeakHashMap();
                    s_aConverter.put(aClass, ret);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _registerTypeConverter(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass, @Nonnull ITypeConverter aConverter) {
        Map<Class<?>, ITypeConverter> aSrcMap;
        if (aSrcClass == null) {
            throw new NullPointerException("srcClass");
        }
        if (!ClassHelper.isPublic(aSrcClass)) {
            throw new IllegalArgumentException("Source " + aSrcClass + " is no public class!");
        }
        if (aDstClass == null) {
            throw new NullPointerException("dstClass");
        }
        if (!ClassHelper.isPublic(aDstClass)) {
            throw new IllegalArgumentException("Destination " + aDstClass + " is no public class!");
        }
        if (aSrcClass.equals(aDstClass)) {
            throw new IllegalArgumentException("Source and destination class are equal and therefore no converter is required.");
        }
        if (aConverter == null) {
            throw new NullPointerException("converter");
        }
        if (aConverter instanceof ITypeConverterRule) {
            throw new IllegalArgumentException("Type converter rules must be registered via registerTypeConverterRule");
        }
        if (ClassHelper.areConvertibleClasses(aSrcClass, aDstClass)) {
            s_aLogger.warn("No type converter needed between " + aSrcClass + " and " + aDstClass + " because types are convertible!");
        }
        if ((aSrcMap = TypeConverterRegistry._getOrCreateConverterMap(aSrcClass)).containsKey(aDstClass)) {
            throw new IllegalArgumentException("A mapping from " + aSrcClass + " to " + aDstClass + " is already defined!");
        }
        s_aRWLock.writeLock().lock();
        try {
            for (WeakReference<Class<?>> aCurWRDstClass : ClassHierarchyCache.getClassHierarchyIterator(aDstClass)) {
                Class aCurDstClass = (Class)aCurWRDstClass.get();
                if (aCurDstClass == null || aSrcMap.containsKey(aCurDstClass) || aSrcMap.put(aCurDstClass, aConverter) == null) continue;
                s_aLogger.warn("Overwriting converter from " + aSrcClass + " to " + aCurDstClass);
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public void registerTypeConverter(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass, @Nonnull ITypeConverter aConverter) {
        TypeConverterRegistry._registerTypeConverter(aSrcClass, aDstClass, aConverter);
    }

    @Override
    public void registerTypeConverter(@Nonnull Class<?>[] aSrcClasses, @Nonnull Class<?> aDstClass, @Nonnull ITypeConverter aConverter) {
        for (Class<?> aSrcClass : aSrcClasses) {
            TypeConverterRegistry._registerTypeConverter(aSrcClass, aDstClass, aConverter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ITypeConverter getExactConverter(@Nullable Class<?> aSrcClass, @Nullable Class<?> aDstClass) {
        s_aRWLock.readLock().lock();
        try {
            Map<Class<?>, ITypeConverter> aConverterMap = s_aConverter.get(aSrcClass);
            ITypeConverter iTypeConverter = aConverterMap == null ? null : aConverterMap.get(aDstClass);
            return iTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ITypeConverter getRuleBasedConverter(@Nullable Class<?> aSrcClass, @Nullable Class<?> aDstClass) {
        if (aSrcClass == null || aDstClass == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            for (Map.Entry aEntry : s_aRules.entrySet()) {
                for (ITypeConverterRule aRule : (List)aEntry.getValue()) {
                    if (!aRule.canConvert(aSrcClass, aDstClass)) continue;
                    ITypeConverterRule iTypeConverterRule = aRule;
                    return iTypeConverterRule;
                }
            }
            ITypeConverter iTypeConverter = null;
            return iTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    private static void _iterateFuzzyConverters(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass, @Nonnull ITypeConverterCallback aCallback) {
        ITypeConverter aConverter;
        Map<Class<?>, ITypeConverter> aConverterMap;
        WeakReference<Class<?>> aCurWRSrcClass;
        Class aCurSrcClass;
        Iterator<WeakReference<Class<?>>> i$ = ClassHierarchyCache.getClassHierarchyIterator(aSrcClass).iterator();
        while (i$.hasNext() && ((aCurSrcClass = (Class)(aCurWRSrcClass = i$.next()).get()) == null || (aConverterMap = s_aConverter.get(aCurSrcClass)) == null || (aConverter = aConverterMap.get(aDstClass)) == null || !aCallback.call(aCurSrcClass, aDstClass, aConverter).isBreak())) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ITypeConverter getFuzzyConverter(final @Nullable Class<?> aSrcClass, final @Nullable Class<?> aDstClass) {
        if (aSrcClass == null || aDstClass == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            if (GlobalDebug.isDebugMode()) {
                final ArrayList aAllConverters = new ArrayList();
                TypeConverterRegistry._iterateFuzzyConverters(aSrcClass, aDstClass, new ITypeConverterCallback(){

                    @Override
                    @Nonnull
                    public EContinue call(@Nonnull Class<?> aCurSrcClass, @Nonnull Class<?> aCurDstClass, @Nonnull ITypeConverter aConverter) {
                        boolean bExact = aSrcClass.equals(aCurSrcClass) && aDstClass.equals(aCurDstClass);
                        aAllConverters.add("[" + aCurSrcClass.getName() + "->" + aCurDstClass.getName() + "]");
                        return bExact ? EContinue.BREAK : EContinue.CONTINUE;
                    }
                });
                if (aAllConverters.size() > 1) {
                    s_aLogger.warn("The fuzzy type converter resolver returned more than 1 match for the conversion from " + aSrcClass + " to " + aDstClass + ": " + aAllConverters);
                }
            }
            final Wrapper ret = new Wrapper();
            TypeConverterRegistry._iterateFuzzyConverters(aSrcClass, aDstClass, new ITypeConverterCallback(){

                @Override
                @Nonnull
                public EContinue call(@Nonnull Class<?> aCurSrcClass, @Nonnull Class<?> aCurDstClass, @Nonnull ITypeConverter aConverter) {
                    ret.set(aConverter);
                    return EContinue.BREAK;
                }
            });
            ITypeConverter iTypeConverter = (ITypeConverter)ret.get();
            return iTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateAllRegisteredTypeConverters(@Nonnull ITypeConverterCallback aCallback) {
        Map<Class<?>, Map<Class<?>, ITypeConverter>> aCopy;
        s_aRWLock.readLock().lock();
        try {
            aCopy = ContainerHelper.newMap(s_aConverter);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        block3: for (Map.Entry<Class<?>, Map<Class<?>, ITypeConverter>> aSrcEntry : aCopy.entrySet()) {
            Class<?> aSrcClass = aSrcEntry.getKey();
            for (Map.Entry<Class<?>, ITypeConverter> aDstEntry : aSrcEntry.getValue().entrySet()) {
                if (!aCallback.call(aSrcClass, aDstEntry.getKey(), aDstEntry.getValue()).isBreak()) continue;
                break block3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int getRegisteredTypeConverterCount() {
        s_aRWLock.readLock().lock();
        try {
            int ret = 0;
            for (Map<Class<?>, ITypeConverter> aMap : s_aConverter.values()) {
                ret += aMap.size();
            }
            int n = ret;
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTypeConverterRule(@Nonnull ITypeConverterRule aTypeConverterRule) {
        if (aTypeConverterRule == null) {
            throw new NullPointerException("typeConverterRule");
        }
        s_aRWLock.writeLock().lock();
        try {
            s_aRules.putSingle(aTypeConverterRule.getSubType(), aTypeConverterRule);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static long getRegisteredTypeConverterRuleCount() {
        s_aRWLock.readLock().lock();
        try {
            long l = s_aRules.getTotalValueCount();
            return l;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (ITypeConverterRegistrarSPI aSPI : ServiceLoaderBackport.load(ITypeConverterRegistrarSPI.class)) {
            aSPI.registerTypeConverter(s_aInstance);
        }
        s_aLogger.info(TypeConverterRegistry.getRegisteredTypeConverterCount() + " type converters and " + TypeConverterRegistry.getRegisteredTypeConverterRuleCount() + " rules registered");
    }
}

