/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import java.io.File;
import java.io.PrintStream;
import org.w3c.jigsaw.pics.InvalidLabelException;
import org.w3c.jigsaw.pics.InvalidLabelFileException;
import org.w3c.jigsaw.pics.LabelInterface;
import org.w3c.jigsaw.pics.LabelParser;

public class SampleLabel
implements LabelInterface {
    private static final int VARSIZE = 8;
    String[] vars = null;
    String[] vals = null;
    int varptr = 0;

    void addBinding(String string, String string2) {
        if (this.varptr + 1 >= this.vars.length) {
            String[] stringArray = new String[this.vars.length * 2];
            String[] stringArray2 = new String[this.vals.length * 2];
            System.arraycopy(this.vars, 0, stringArray, 0, this.vars.length);
            System.arraycopy(this.vals, 0, stringArray2, 0, this.vals.length);
            this.vars = stringArray;
            this.vals = stringArray2;
        }
        this.vars[this.varptr] = string;
        this.vals[this.varptr] = string2;
        ++this.varptr;
    }

    public void print(PrintStream printStream) {
        for (int i = 0; i < this.varptr; ++i) {
            System.out.println("\t" + this.vars[i] + " = " + this.vals[i]);
        }
    }

    public boolean hasOption(String string) {
        for (int i = 0; i < this.varptr; ++i) {
            if (!this.vars[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getOptionIndex(String string) {
        for (int i = 0; i < this.varptr; ++i) {
            if (!this.vars[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getOptionValue(int n) {
        if (n < 0 || n >= this.varptr) {
            throw new RuntimeException(this.getClass().getName() + "[getOptionValue]: " + " invalid index.");
        }
        return this.vals[n];
    }

    public String getOptionValue(String string) {
        for (int i = 0; i < this.varptr; ++i) {
            if (!this.vars[i].equals(string)) continue;
            return this.vals[i];
        }
        return null;
    }

    public boolean isGeneric() {
        int n = this.getOptionIndex("generic");
        if (n >= 0) {
            return new Boolean(this.getOptionValue(n));
        }
        return false;
    }

    private boolean emit(boolean bl, StringBuffer stringBuffer, String string, int n) {
        String string2 = this.getOptionValue(string);
        if (string2 != null) {
            switch (n) {
                case 1: 
                case 2: {
                    if (bl) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string + " " + string2);
                    break;
                }
                default: {
                    if (bl) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string + " " + string2);
                }
            }
            return true;
        }
        return false;
    }

    private void emit(boolean bl, StringBuffer stringBuffer, int n, int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                if (bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.vars[n] + " " + this.vals[n]);
                break;
            }
            default: {
                if (bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.vars[n] + " " + this.vals[n]);
            }
        }
    }

    public void dump(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (this.isGeneric()) {
                    this.emit(bl, stringBuffer, "generic", 1);
                    bl = true;
                    this.emit(bl, stringBuffer, "for", 1);
                    this.emit(bl, stringBuffer, "ratings", 1);
                    break;
                }
                this.emit(bl, stringBuffer, "ratings", 1);
                break;
            }
            case 2: {
                if (this.isGeneric()) {
                    this.emit(bl, stringBuffer, "generic", 2);
                    bl = true;
                    this.emit(bl, stringBuffer, "for", 2);
                    this.emit(bl, stringBuffer, "full", 2);
                    this.emit(bl, stringBuffer, "ratings", 2);
                    break;
                }
                this.emit(bl, stringBuffer, "full", 2);
                bl = true;
                this.emit(bl, stringBuffer, "ratings", 2);
                break;
            }
            case 3: {
                for (int i = 0; i < this.varptr; ++i) {
                    if (this.vars[i].equals("ratings")) continue;
                    this.emit(bl, stringBuffer, i, 3);
                    bl = true;
                }
                this.emit(bl, stringBuffer, "ratings", 3);
                break;
            }
            case 4: {
                throw new RuntimeException(this.getClass().getName() + "[dump]: " + "SIGNED format unsupported.");
            }
            default: {
                throw new RuntimeException(this.getClass().getName() + "[dump]: " + " invalid format " + "\"" + n + "\"");
            }
        }
    }

    SampleLabel(File file) throws InvalidLabelException {
        try {
            this.vars = new String[8];
            this.vals = new String[8];
            this.varptr = 0;
            LabelParser labelParser = new LabelParser(file);
            labelParser.parse(this);
        }
        catch (InvalidLabelException invalidLabelException) {
            throw new InvalidLabelFileException(invalidLabelException.getMessage());
        }
    }

    SampleLabel(String string) throws InvalidLabelException {
        this.vars = new String[8];
        this.vals = new String[8];
        this.varptr = 0;
        LabelParser labelParser = new LabelParser(string);
        labelParser.parse(this);
    }

    public SampleLabel(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw new RuntimeException(this.getClass().getName() + " invalid constructor params:" + " bad length.");
        }
        this.vars = stringArray;
        this.vals = stringArray2;
        this.varptr = stringArray.length;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Label <file>");
            System.exit(1);
        }
        try {
            SampleLabel sampleLabel = new SampleLabel(new File(stringArray[0]));
            StringBuffer stringBuffer = new StringBuffer();
            sampleLabel.dump(stringBuffer, 1);
            System.out.println(stringBuffer.toString());
        }
        catch (InvalidLabelException invalidLabelException) {
            System.out.println(invalidLabelException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

