/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.HttpServer;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.RequestObserver;

public class Request
extends HttpRequestMessage {
    protected HttpManager manager = null;
    protected boolean allowuserinteraction = false;
    protected InputStream output = null;
    protected RequestObserver observer = null;
    protected boolean pipeline = true;
    protected boolean interrupted = false;
    protected HttpServer server = null;

    protected synchronized void setServer(HttpServer httpServer) {
        this.server = httpServer;
    }

    protected synchronized void unsetServer() {
        this.server = null;
    }

    public void setPipeline(boolean bl) {
        this.pipeline = bl;
    }

    protected void endEmit(OutputStream outputStream, int n) throws IOException {
        if ((n & 4) != 4) {
            return;
        }
        if (this.output != null) {
            byte[] byArray = new byte[1024];
            int n2 = 0;
            int n3 = 0;
            while ((n2 = this.output.read(byArray)) >= 0) {
                n3 += n2;
                outputStream.write(byArray, 0, n2);
            }
        }
    }

    public boolean getAllowUserInteraction() {
        return this.allowuserinteraction;
    }

    public void setAllowUserInteraction(boolean bl) {
        this.allowuserinteraction = bl;
    }

    public synchronized void interruptRequest() {
        this.interrupted = true;
        if (this.server != null) {
            this.server.interruptRequest(this);
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public HttpManager getManager() {
        return this.manager;
    }

    public void setOutputStream(InputStream inputStream) {
        this.output = inputStream;
        this.pipeline = false;
    }

    public boolean hasOutputStream() {
        return this.output != null;
    }

    public InputStream getOutputStream() {
        return this.output;
    }

    public Reply makeReply(int n) {
        return new Reply(this.major, this.minor, n);
    }

    public void setObserver(RequestObserver requestObserver) {
        this.observer = requestObserver;
    }

    public RequestObserver getObserver() {
        return this.observer;
    }

    protected Request(HttpManager httpManager) {
        this.manager = httpManager;
    }
}

