/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CascadingStyleSheet {
    private final List<CSSImportRule> m_aImportRules = new ArrayList<CSSImportRule>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();

    public void addImportRule(@Nonnull CSSImportRule aImportRule) {
        if (aImportRule == null) {
            throw new NullPointerException("importRule");
        }
        this.m_aImportRules.add(aImportRule);
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule aImportRule) {
        return EChange.valueOf((boolean)this.m_aImportRules.remove(aImportRule));
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int nImportRuleIndex) {
        if (nImportRuleIndex < 0 || nImportRuleIndex >= this.m_aImportRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aImportRules.remove(nImportRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSImportRule> getAllImportRules() {
        return ContainerHelper.newList(this.m_aImportRules);
    }

    public void addRule(@Nonnull ICSSTopLevelRule aStyleRule) {
        if (aStyleRule == null) {
            throw new NullPointerException("styleRule");
        }
        this.m_aRules.add(aStyleRule);
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule aRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(aRule));
    }

    public EChange removeRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(nRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSStyleRule> getAllStyleRules() {
        ArrayList<CSSStyleRule> ret = new ArrayList<CSSStyleRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSStyleRule)) continue;
            ret.add((CSSStyleRule)aTopLevelRule);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSPageRule> getAllPageRules() {
        ArrayList<CSSPageRule> ret = new ArrayList<CSSPageRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSPageRule)) continue;
            ret.add((CSSPageRule)aTopLevelRule);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaRule> getAllMediaRules() {
        ArrayList<CSSMediaRule> ret = new ArrayList<CSSMediaRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSMediaRule)) continue;
            ret.add((CSSMediaRule)aTopLevelRule);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSFontFaceRule> getAllFontFaceRules() {
        ArrayList<CSSFontFaceRule> ret = new ArrayList<CSSFontFaceRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSFontFaceRule)) continue;
            ret.add((CSSFontFaceRule)aTopLevelRule);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesRule> getAllKeyframesRules() {
        ArrayList<CSSKeyframesRule> ret = new ArrayList<CSSKeyframesRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSKeyframesRule)) continue;
            ret.add((CSSKeyframesRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CascadingStyleSheet)) {
            return false;
        }
        CascadingStyleSheet rhs = (CascadingStyleSheet)o;
        return ((Object)this.m_aImportRules).equals(rhs.m_aImportRules) && ((Object)this.m_aRules).equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("rules", this.m_aRules).toString();
    }
}

