/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Properties;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;

public abstract class CollatingFunctionFixed
extends SystemFunction {
    private String collationName;
    private StringCollator stringCollator = null;
    private AtomicComparer atomicComparer = null;

    public StringCollator getStringCollator() {
        return this.stringCollator;
    }

    public void setRetainedStaticContext(RetainedStaticContext retainedStaticContext) {
        super.setRetainedStaticContext(retainedStaticContext);
        if (this.collationName == null) {
            this.collationName = retainedStaticContext.getDefaultCollationName();
            try {
                this.allocateCollator();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public void setCollationName(String collationName) throws XPathException {
        this.collationName = collationName;
        this.allocateCollator();
    }

    private void allocateCollator() throws XPathException {
        this.stringCollator = this.getRetainedStaticContext().getConfiguration().getCollation(this.collationName);
        if (this.stringCollator == null) {
            throw new XPathException("Unknown collation " + this.collationName, "FOCH0002");
        }
    }

    protected void preAllocateComparer(AtomicType type0, AtomicType type1, StaticContext env, boolean NaNequalsNaN) {
        StringCollator collation = this.getStringCollator();
        if (type0 == ErrorType.getInstance() || type1 == ErrorType.getInstance()) {
            this.atomicComparer = EqualityComparer.getInstance();
            return;
        }
        this.atomicComparer = NaNequalsNaN ? AtomicSortComparer.makeSortComparer(collation, type0.getPrimitiveType(), env.makeEarlyEvaluationContext()) : GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)type0.getBuiltInBaseType(), (BuiltInAtomicType)type1.getBuiltInBaseType(), this.stringCollator, env.makeEarlyEvaluationContext());
    }

    public AtomicComparer getPreAllocatedAtomicComparer() {
        return this.atomicComparer;
    }

    public AtomicComparer getAtomicComparer(XPathContext context) {
        if (this.atomicComparer != null) {
            return this.atomicComparer.provideContext(context);
        }
        return new GenericAtomicComparer(this.getStringCollator(), context);
    }

    public void exportAttributes(ExpressionPresenter out) {
        if (!this.collationName.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            out.emitAttribute("collation", this.collationName);
        }
    }

    public void importAttributes(Properties attributes) throws XPathException {
        String collationName = attributes.getProperty("collation");
        if (collationName != null) {
            this.setCollationName(collationName);
        }
    }
}

