/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ArraySort
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("array", "http://www.w3.org/2005/xpath-functions/array", "sort");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{ArrayItem.SINGLE_ARRAY_TYPE, SequenceType.OPTIONAL_ITEM, SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.ANY_SEQUENCE}, SequenceType.ATOMIC_SEQUENCE), 16384)};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return suppliedArgumentTypes[0];
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ArraySortCall();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static int compareSortKeys(GroundedValue a, GroundedValue b, AtomicComparer comparer) {
        UnfailingIterator iteratora = a.iterate();
        UnfailingIterator iteratorb = b.iterate();
        while (true) {
            AtomicValue firsta = (AtomicValue)iteratora.next();
            AtomicValue firstb = (AtomicValue)iteratorb.next();
            if (firsta == null) {
                if (firstb != null) return -1;
                return 0;
            }
            if (firstb == null) {
                return 1;
            }
            try {
                int first = comparer.compareAtomicValues(firsta, firstb);
                if (first != 0) return first;
            }
            catch (NoDynamicContextException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static GroundedValue atomize(Sequence input) throws XPathException {
        try {
            SequenceIterator iterator = input.iterate();
            SequenceIterator mapper = Atomizer.getAtomizingIterator(iterator, false);
            return SequenceExtent.makeSequenceExtent(mapper);
        }
        catch (XPathException e) {
            throw new XPathException(e);
        }
    }

    private static class ArraySortCall
    extends ExtensionFunctionCall {
        RetainedStaticContext rsc;

        private ArraySortCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.rsc = context.makeRetainedStaticContext();
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((ArraySortCall)destination).rsc = this.rsc;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            final ArrayList<MemberToBeSorted> inputList = new ArrayList<MemberToBeSorted>(array.size());
            int i = 0;
            Function key = null;
            StringCollator collation = null;
            if (arguments.length == 1) {
                collation = context.getConfiguration().getCollation(this.rsc.getDefaultCollationName());
            } else {
                Item second = arguments[1].head();
                if (second == null) {
                    collation = context.getConfiguration().getCollation(this.rsc.getDefaultCollationName());
                } else if (second instanceof StringValue) {
                    String collName = second.getStringValue();
                    collation = context.getConfiguration().getCollation(collName, this.rsc.getStaticBaseUriString());
                } else if (second instanceof Function) {
                    context.getController().getErrorListener().warning(new XPathException("Using obsolete function signature of array:sort()"));
                    collation = context.getConfiguration().getCollation(this.rsc.getDefaultCollationName());
                    key = (Function)second;
                } else {
                    throw new XPathException("Second argument of array:sort must be either a collation or a comparison function", "XPTY0004");
                }
            }
            if (arguments.length == 3) {
                key = (Function)arguments[2].head();
            }
            for (Sequence seq : array) {
                MemberToBeSorted member = new MemberToBeSorted();
                member.value = seq;
                member.originalPosition = i++;
                member.sortKey = key != null ? SequenceTool.toGroundedValue(key.call(context, new Sequence[]{seq})) : ArraySort.atomize(seq);
                inputList.add(member);
            }
            final AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(collation, 632, context);
            Sortable sortable = new Sortable(){

                public int compare(int a, int b) {
                    int result = ArraySort.compareSortKeys(((MemberToBeSorted)inputList.get((int)a)).sortKey, ((MemberToBeSorted)inputList.get((int)b)).sortKey, atomicComparer);
                    if (result == 0) {
                        return ((MemberToBeSorted)inputList.get((int)a)).originalPosition - ((MemberToBeSorted)inputList.get((int)b)).originalPosition;
                    }
                    return result;
                }

                public void swap(int a, int b) {
                    MemberToBeSorted temp = (MemberToBeSorted)inputList.get(a);
                    inputList.set(a, inputList.get(b));
                    inputList.set(b, temp);
                }
            };
            try {
                GenericSorter.quickSort(0, array.size(), sortable);
            }
            catch (ClassCastException e) {
                XPathException err = new XPathException("Non-comparable types found while sorting: " + e.getMessage());
                err.setErrorCode("XPTY0004");
                throw err;
            }
            ArrayList<Sequence> outputList = new ArrayList<Sequence>(array.size());
            for (MemberToBeSorted member : inputList) {
                outputList.add(member.value);
            }
            return new SimpleArrayItem(outputList);
        }
    }

    private static class MemberToBeSorted {
        public Sequence value;
        public GroundedValue sortKey;
        int originalPosition;

        private MemberToBeSorted() {
        }
    }
}

